"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def authorize(
    hub,
    ctx,
    group_id: str,
    dry_run: bool = None,
    ip_permissions: List = None,
    tag_specifications: List = None,
    cidr_ip: str = None,
    from_port: int = None,
    ip_protocol: str = None,
    to_port: int = None,
    source_security_group_name: str = None,
    source_security_group_owner_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    [VPC only] Adds the specified outbound (egress) rules to a security group for use with a VPC. An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address ranges, or to the instances that are associated with the specified destination security groups. You specify a protocol for each rule (for example, TCP). For the TCP and UDP protocols, you must also specify the destination port or port range. For the ICMP protocol, you must also specify the ICMP type and code. You can use -1 for the type or code to mean all types or all codes. Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur. For information about VPC security group quotas, see Amazon VPC quotas.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        group_id(str): The ID of the security group.
        ip_permissions(List, optional): The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions. Defaults to None.
        tag_specifications(List, optional): The tags applied to the security group rule. Defaults to None.
        cidr_ip(str, optional): Not supported. Use a set of IP permissions to specify the CIDR. Defaults to None.
        from_port(int, optional): Not supported. Use a set of IP permissions to specify the port. Defaults to None.
        ip_protocol(str, optional): Not supported. Use a set of IP permissions to specify the protocol name or number. Defaults to None.
        to_port(int, optional): Not supported. Use a set of IP permissions to specify the port. Defaults to None.
        source_security_group_name(str, optional): Not supported. Use a set of IP permissions to specify a destination security group. Defaults to None.
        source_security_group_owner_id(str, optional): Not supported. Use a set of IP permissions to specify a destination security group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.security_group.egress.authorize(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.security_group.egress.authorize group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="authorize_security_group_egress",
        op_kwargs={
            "DryRun": dry_run,
            "GroupId": group_id,
            "IpPermissions": ip_permissions,
            "TagSpecifications": tag_specifications,
            "CidrIp": cidr_ip,
            "FromPort": from_port,
            "IpProtocol": ip_protocol,
            "ToPort": to_port,
            "SourceSecurityGroupName": source_security_group_name,
            "SourceSecurityGroupOwnerId": source_security_group_owner_id,
        },
    )


async def revoke(
    hub,
    ctx,
    group_id: str,
    dry_run: bool = None,
    ip_permissions: List = None,
    security_group_rule_ids: List = None,
    cidr_ip: str = None,
    from_port: int = None,
    ip_protocol: str = None,
    to_port: int = None,
    source_security_group_name: str = None,
    source_security_group_owner_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    [VPC only] Removes the specified outbound (egress) rules from a security group for EC2-VPC. This action does not apply to security groups for use in EC2-Classic. You can specify rules using either rule IDs or security group rule properties. If you use rule properties, the values that you specify (for example, ports) must match the existing rule's values exactly. Each rule has a protocol, from and to ports, and destination (CIDR range, security group, or prefix list). For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code. If the security group rule has a description, you do not need to specify the description to revoke the rule. [Default VPC] If the values you specify do not match the existing rule's values, no error is returned, and the output describes the security group rules that were not revoked. Amazon Web Services recommends that you describe the security group to verify that the rules were removed. Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        group_id(str): The ID of the security group.
        ip_permissions(List, optional): The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions. Defaults to None.
        security_group_rule_ids(List, optional): The IDs of the security group rules. Defaults to None.
        cidr_ip(str, optional): Not supported. Use a set of IP permissions to specify the CIDR. Defaults to None.
        from_port(int, optional): Not supported. Use a set of IP permissions to specify the port. Defaults to None.
        ip_protocol(str, optional): Not supported. Use a set of IP permissions to specify the protocol name or number. Defaults to None.
        to_port(int, optional): Not supported. Use a set of IP permissions to specify the port. Defaults to None.
        source_security_group_name(str, optional): Not supported. Use a set of IP permissions to specify a destination security group. Defaults to None.
        source_security_group_owner_id(str, optional): Not supported. Use a set of IP permissions to specify a destination security group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.security_group.egress.revoke(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.security_group.egress.revoke group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="revoke_security_group_egress",
        op_kwargs={
            "DryRun": dry_run,
            "GroupId": group_id,
            "IpPermissions": ip_permissions,
            "SecurityGroupRuleIds": security_group_rule_ids,
            "CidrIp": cidr_ip,
            "FromPort": from_port,
            "IpProtocol": ip_protocol,
            "ToPort": to_port,
            "SourceSecurityGroupName": source_security_group_name,
            "SourceSecurityGroupOwnerId": source_security_group_owner_id,
        },
    )
