"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    scheduled_instance_ids: List = None,
    slot_start_time_range: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified Scheduled Instances or all your Scheduled Instances.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filters(List, optional): The filters.    availability-zone - The Availability Zone (for example, us-west-2a).    instance-type - The instance type (for example, c4.large).    network-platform - The network platform (EC2-Classic or EC2-VPC).    platform - The platform (Linux/UNIX or Windows).  . Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 100. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        scheduled_instance_ids(List, optional): The Scheduled Instance IDs. Defaults to None.
        slot_start_time_range(Dict, optional): The time period for the first schedule to start. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.scheduled_instance.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.scheduled_instance.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_scheduled_instances",
        op_kwargs={
            "DryRun": dry_run,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ScheduledInstanceIds": scheduled_instance_ids,
            "SlotStartTimeRange": slot_start_time_range,
        },
    )


async def purchase(
    hub, ctx, purchase_requests: List, client_token: str = None, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Purchases the Scheduled Instances with the specified schedule. Scheduled Instances enable you to purchase Amazon EC2 compute capacity by the hour for a one-year term. Before you can purchase a Scheduled Instance, you must call DescribeScheduledInstanceAvailability to check for available schedules and obtain a purchase token. After you purchase a Scheduled Instance, you must call RunScheduledInstances during each scheduled time period. After you purchase a Scheduled Instance, you can't cancel, modify, or resell your purchase.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see Ensuring Idempotency. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        purchase_requests(List): The purchase requests.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.scheduled_instance.init.purchase(
                ctx, purchase_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.scheduled_instance.init.purchase purchase_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="purchase_scheduled_instances",
        op_kwargs={
            "ClientToken": client_token,
            "DryRun": dry_run,
            "PurchaseRequests": purchase_requests,
        },
    )


async def run(
    hub,
    ctx,
    launch_specification: Dict,
    scheduled_instance_id: str,
    client_token: str = None,
    dry_run: bool = None,
    instance_count: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Launches the specified Scheduled Instances. Before you can launch a Scheduled Instance, you must purchase it and obtain an identifier using PurchaseScheduledInstances. You must launch a Scheduled Instance during its scheduled time period. You can't stop or reboot a Scheduled Instance, but you can terminate it as needed. If you terminate a Scheduled Instance before the current scheduled time period ends, you can launch it again after a few minutes. For more information, see Scheduled Instances in the Amazon EC2 User Guide.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see Ensuring Idempotency. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_count(int, optional): The number of instances. Default: 1. Defaults to None.
        launch_specification(Dict): The launch specification. You must match the instance type, Availability Zone, network, and platform of the schedule that you purchased.
        scheduled_instance_id(str): The Scheduled Instance ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.scheduled_instance.init.run(
                ctx, launch_specification=value, scheduled_instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.scheduled_instance.init.run launch_specification=value, scheduled_instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="run_scheduled_instances",
        op_kwargs={
            "ClientToken": client_token,
            "DryRun": dry_run,
            "InstanceCount": instance_count,
            "LaunchSpecification": launch_specification,
            "ScheduledInstanceId": scheduled_instance_id,
        },
    )
