"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    first_slot_start_time_range: Dict,
    recurrence: Dict,
    dry_run: bool = None,
    filters: List = None,
    max_results: int = None,
    max_slot_duration_in_hours: int = None,
    min_slot_duration_in_hours: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Finds available schedules that meet the specified criteria. You can search for an available schedule no more than 3 months in advance. You must meet the minimum required duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours. After you find a schedule that meets your needs, call PurchaseScheduledInstances to purchase Scheduled Instances with that schedule.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filters(List, optional): The filters.    availability-zone - The Availability Zone (for example, us-west-2a).    instance-type - The instance type (for example, c4.large).    network-platform - The network platform (EC2-Classic or EC2-VPC).    platform - The platform (Linux/UNIX or Windows).  . Defaults to None.
        first_slot_start_time_range(Dict): The time period for the first schedule to start.
        max_results(int, optional): The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 300. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        max_slot_duration_in_hours(int, optional): The maximum available duration, in hours. This value must be greater than MinSlotDurationInHours and less than 1,720. Defaults to None.
        min_slot_duration_in_hours(int, optional): The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        recurrence(Dict): The schedule recurrence.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.scheduled_instance.availability.describe(
                ctx, first_slot_start_time_range=value, recurrence=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.scheduled_instance.availability.describe first_slot_start_time_range=value, recurrence=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_scheduled_instance_availability",
        op_kwargs={
            "DryRun": dry_run,
            "Filters": filters,
            "FirstSlotStartTimeRange": first_slot_start_time_range,
            "MaxResults": max_results,
            "MaxSlotDurationInHours": max_slot_duration_in_hours,
            "MinSlotDurationInHours": min_slot_duration_in_hours,
            "NextToken": next_token,
            "Recurrence": recurrence,
        },
    )
