"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def replace(
    hub, ctx, association_id: str, route_table_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Changes the route table associated with a given subnet, internet gateway, or virtual private gateway in a VPC. After the operation completes, the subnet or gateway uses the routes in the new route table. For more information about route tables, see Route tables in the Amazon Virtual Private Cloud User Guide. You can also use this operation to change which table is the main route table in the VPC. Specify the main route table's association ID and the route table ID of the new main route table.

    Args:
        association_id(str): The association ID.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        route_table_id(str): The ID of the new route table to associate with the subnet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.route.table.association.replace(
                ctx, association_id=value, route_table_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.route.table.association.replace association_id=value, route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="replace_route_table_association",
        op_kwargs={
            "AssociationId": association_id,
            "DryRun": dry_run,
            "RouteTableId": route_table_id,
        },
    )
