"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    route_table_id: str,
    destination_cidr_block: str = None,
    destination_ipv6_cidr_block: str = None,
    destination_prefix_list_id: str = None,
    dry_run: bool = None,
    vpc_endpoint_id: str = None,
    egress_only_internet_gateway_id: str = None,
    gateway_id: str = None,
    instance_id: str = None,
    nat_gateway_id: str = None,
    transit_gateway_id: str = None,
    local_gateway_id: str = None,
    carrier_gateway_id: str = None,
    network_interface_id: str = None,
    vpc_peering_connection_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a route in a route table within a VPC. You must specify one of the following targets: internet gateway or virtual private gateway, NAT instance, NAT gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway. When determining how to route traffic, we use the route with the most specific match. For example, traffic is destined for the IPv4 address 192.0.2.3, and the route table includes the following two IPv4 routes:    192.0.2.0/24 (goes to some target A)    192.0.2.0/28 (goes to some target B)   Both routes apply to the traffic destined for 192.0.2.3. However, the second route in the list covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where to target the traffic. For more information about route tables, see Route tables in the Amazon Virtual Private Cloud User Guide.

    Args:
        destination_cidr_block(str, optional): The IPv4 CIDR address block used for the destination match. Routing decisions are based on the most specific match. We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18. Defaults to None.
        destination_ipv6_cidr_block(str, optional): The IPv6 CIDR block used for the destination match. Routing decisions are based on the most specific match. Defaults to None.
        destination_prefix_list_id(str, optional): The ID of a prefix list used for the destination match. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        vpc_endpoint_id(str, optional): The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only. Defaults to None.
        egress_only_internet_gateway_id(str, optional): [IPv6 traffic only] The ID of an egress-only internet gateway. Defaults to None.
        gateway_id(str, optional): The ID of an internet gateway or virtual private gateway attached to your VPC. Defaults to None.
        instance_id(str, optional): The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached. Defaults to None.
        nat_gateway_id(str, optional): [IPv4 traffic only] The ID of a NAT gateway. Defaults to None.
        transit_gateway_id(str, optional): The ID of a transit gateway. Defaults to None.
        local_gateway_id(str, optional): The ID of the local gateway. Defaults to None.
        carrier_gateway_id(str, optional): The ID of the carrier gateway. You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone. Defaults to None.
        network_interface_id(str, optional): The ID of a network interface. Defaults to None.
        route_table_id(str): The ID of the route table for the route.
        vpc_peering_connection_id(str, optional): The ID of a VPC peering connection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.route.init.create(ctx, route_table_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.route.init.create route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_route",
        op_kwargs={
            "DestinationCidrBlock": destination_cidr_block,
            "DestinationIpv6CidrBlock": destination_ipv6_cidr_block,
            "DestinationPrefixListId": destination_prefix_list_id,
            "DryRun": dry_run,
            "VpcEndpointId": vpc_endpoint_id,
            "EgressOnlyInternetGatewayId": egress_only_internet_gateway_id,
            "GatewayId": gateway_id,
            "InstanceId": instance_id,
            "NatGatewayId": nat_gateway_id,
            "TransitGatewayId": transit_gateway_id,
            "LocalGatewayId": local_gateway_id,
            "CarrierGatewayId": carrier_gateway_id,
            "NetworkInterfaceId": network_interface_id,
            "RouteTableId": route_table_id,
            "VpcPeeringConnectionId": vpc_peering_connection_id,
        },
    )


async def delete(
    hub,
    ctx,
    route_table_id: str,
    destination_cidr_block: str = None,
    destination_ipv6_cidr_block: str = None,
    destination_prefix_list_id: str = None,
    dry_run: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified route from the specified route table.

    Args:
        destination_cidr_block(str, optional): The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly. Defaults to None.
        destination_ipv6_cidr_block(str, optional): The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly. Defaults to None.
        destination_prefix_list_id(str, optional): The ID of the prefix list for the route. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        route_table_id(str): The ID of the route table.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.route.init.delete(ctx, route_table_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.route.init.delete route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_route",
        op_kwargs={
            "DestinationCidrBlock": destination_cidr_block,
            "DestinationIpv6CidrBlock": destination_ipv6_cidr_block,
            "DestinationPrefixListId": destination_prefix_list_id,
            "DryRun": dry_run,
            "RouteTableId": route_table_id,
        },
    )


async def replace(
    hub,
    ctx,
    route_table_id: str,
    destination_cidr_block: str = None,
    destination_ipv6_cidr_block: str = None,
    destination_prefix_list_id: str = None,
    dry_run: bool = None,
    vpc_endpoint_id: str = None,
    egress_only_internet_gateway_id: str = None,
    gateway_id: str = None,
    instance_id: str = None,
    local_target: bool = None,
    nat_gateway_id: str = None,
    transit_gateway_id: str = None,
    local_gateway_id: str = None,
    carrier_gateway_id: str = None,
    network_interface_id: str = None,
    vpc_peering_connection_id: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Replaces an existing route within a route table in a VPC. You must provide only one of the following: internet gateway, virtual private gateway, NAT instance, NAT gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway. For more information, see Route tables in the Amazon Virtual Private Cloud User Guide.

    Args:
        destination_cidr_block(str, optional): The IPv4 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table. Defaults to None.
        destination_ipv6_cidr_block(str, optional): The IPv6 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table. Defaults to None.
        destination_prefix_list_id(str, optional): The ID of the prefix list for the route. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        vpc_endpoint_id(str, optional): The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only. Defaults to None.
        egress_only_internet_gateway_id(str, optional): [IPv6 traffic only] The ID of an egress-only internet gateway. Defaults to None.
        gateway_id(str, optional): The ID of an internet gateway or virtual private gateway. Defaults to None.
        instance_id(str, optional): The ID of a NAT instance in your VPC. Defaults to None.
        local_target(bool, optional): Specifies whether to reset the local route to its default target (local). Defaults to None.
        nat_gateway_id(str, optional): [IPv4 traffic only] The ID of a NAT gateway. Defaults to None.
        transit_gateway_id(str, optional): The ID of a transit gateway. Defaults to None.
        local_gateway_id(str, optional): The ID of the local gateway. Defaults to None.
        carrier_gateway_id(str, optional): [IPv4 traffic only] The ID of a carrier gateway. Defaults to None.
        network_interface_id(str, optional): The ID of a network interface. Defaults to None.
        route_table_id(str): The ID of the route table.
        vpc_peering_connection_id(str, optional): The ID of a VPC peering connection. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.route.init.replace(ctx, route_table_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.route.init.replace route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="replace_route",
        op_kwargs={
            "DestinationCidrBlock": destination_cidr_block,
            "DestinationIpv6CidrBlock": destination_ipv6_cidr_block,
            "DestinationPrefixListId": destination_prefix_list_id,
            "DryRun": dry_run,
            "VpcEndpointId": vpc_endpoint_id,
            "EgressOnlyInternetGatewayId": egress_only_internet_gateway_id,
            "GatewayId": gateway_id,
            "InstanceId": instance_id,
            "LocalTarget": local_target,
            "NatGatewayId": nat_gateway_id,
            "TransitGatewayId": transit_gateway_id,
            "LocalGatewayId": local_gateway_id,
            "CarrierGatewayId": carrier_gateway_id,
            "NetworkInterfaceId": network_interface_id,
            "RouteTableId": route_table_id,
            "VpcPeeringConnectionId": vpc_peering_connection_id,
        },
    )
