"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    availability_zone: str = None,
    filters: List = None,
    include_marketplace: bool = None,
    instance_type: str = None,
    max_duration: int = None,
    max_instance_count: int = None,
    min_duration: int = None,
    offering_class: str = None,
    product_description: str = None,
    reserved_instances_offering_ids: List = None,
    dry_run: bool = None,
    instance_tenancy: str = None,
    max_results: int = None,
    next_token: str = None,
    offering_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the right to launch instances for a period of time. During that time period, you do not receive insufficient capacity errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used. If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be excluded from these results. This is to ensure that you do not purchase your own Reserved Instances. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.

    Args:
        availability_zone(str, optional): The Availability Zone in which the Reserved Instance can be used. Defaults to None.
        filters(List, optional): One or more filters.    availability-zone - The Availability Zone where the Reserved Instance can be used.    duration - The duration of the Reserved Instance (for example, one year or three years), in seconds (31536000 | 94608000).    fixed-price - The purchase price of the Reserved Instance (for example, 9800.0).    instance-type - The instance type that is covered by the reservation.    marketplace - Set to true to show only Reserved Instance Marketplace offerings. When this filter is not used, which is the default behavior, all offerings from both Amazon Web Services and the Reserved Instance Marketplace are listed.    product-description - The Reserved Instance product platform description. Instances that include (Amazon VPC) in the product platform description will only be displayed to EC2-Classic account holders and are for use with Amazon VPC. (Linux/UNIX | Linux/UNIX (Amazon VPC) | SUSE Linux | SUSE Linux (Amazon VPC) | Red Hat Enterprise Linux | Red Hat Enterprise Linux (Amazon VPC) | Red Hat Enterprise Linux with HA (Amazon VPC) | Windows | Windows (Amazon VPC) | Windows with SQL Server Standard | Windows with SQL Server Standard (Amazon VPC) | Windows with SQL Server Web |  Windows with SQL Server Web (Amazon VPC) | Windows with SQL Server Enterprise | Windows with SQL Server Enterprise (Amazon VPC))     reserved-instances-offering-id - The Reserved Instances offering ID.    scope - The scope of the Reserved Instance (Availability Zone or Region).    usage-price - The usage price of the Reserved Instance, per hour (for example, 0.84).  . Defaults to None.
        include_marketplace(bool, optional): Include Reserved Instance Marketplace offerings in the response. Defaults to None.
        instance_type(str, optional): The instance type that the reservation will cover (for example, m1.small). For more information, see Instance types in the Amazon EC2 User Guide. Defaults to None.
        max_duration(int, optional): The maximum duration (in seconds) to filter when searching for offerings. Default: 94608000 (3 years). Defaults to None.
        max_instance_count(int, optional): The maximum number of instances to filter when searching for offerings. Default: 20. Defaults to None.
        min_duration(int, optional): The minimum duration (in seconds) to filter when searching for offerings. Default: 2592000 (1 month). Defaults to None.
        offering_class(str, optional): The offering class of the Reserved Instance. Can be standard or convertible. Defaults to None.
        product_description(str, optional): The Reserved Instance product platform description. Instances that include (Amazon VPC) in the description are for use with Amazon VPC. Defaults to None.
        reserved_instances_offering_ids(List, optional): One or more Reserved Instances offering IDs. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_tenancy(str, optional): The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of dedicated is applied to instances that run in a VPC on single-tenant hardware (i.e., Dedicated Instances).  Important: The host value cannot be used with this parameter. Use the default or dedicated values only. Default: default . Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned NextToken value. The maximum is 100. Default: 100. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.
        offering_type(str, optional): The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only have access to the Medium Utilization Reserved Instance offering type. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.reserved_instance.offering.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.reserved_instance.offering.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_reserved_instances_offerings",
        op_kwargs={
            "AvailabilityZone": availability_zone,
            "Filters": filters,
            "IncludeMarketplace": include_marketplace,
            "InstanceType": instance_type,
            "MaxDuration": max_duration,
            "MaxInstanceCount": max_instance_count,
            "MinDuration": min_duration,
            "OfferingClass": offering_class,
            "ProductDescription": product_description,
            "ReservedInstancesOfferingIds": reserved_instances_offering_ids,
            "DryRun": dry_run,
            "InstanceTenancy": instance_tenancy,
            "MaxResults": max_results,
            "NextToken": next_token,
            "OfferingType": offering_type,
        },
    )


async def purchase(
    hub,
    ctx,
    instance_count: int,
    reserved_instances_offering_id: str,
    dry_run: bool = None,
    limit_price: Dict = None,
    purchase_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay a lower hourly rate compared to On-Demand instance pricing. Use DescribeReservedInstancesOfferings to get a list of Reserved Instance offerings that match your specifications. After you've purchased a Reserved Instance, you can check for your new Reserved Instance with DescribeReservedInstances. To queue a purchase for a future date and time, specify a purchase time. If you do not specify a purchase time, the default is the current time. For more information, see Reserved Instances and Reserved Instance Marketplace in the Amazon EC2 User Guide.

    Args:
        instance_count(int): The number of Reserved Instances to purchase.
        reserved_instances_offering_id(str): The ID of the Reserved Instance offering to purchase.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        limit_price(Dict, optional): Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved Instances are not purchased at unexpected prices. Defaults to None.
        purchase_time(str, optional): The time at which to purchase the Reserved Instance, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.reserved_instance.offering.purchase(
                ctx, instance_count=value, reserved_instances_offering_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.reserved_instance.offering.purchase instance_count=value, reserved_instances_offering_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="purchase_reserved_instances_offering",
        op_kwargs={
            "InstanceCount": instance_count,
            "ReservedInstancesOfferingId": reserved_instances_offering_id,
            "DryRun": dry_run,
            "LimitPrice": limit_price,
            "PurchaseTime": purchase_time,
        },
    )
