"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, reserved_instances_listing_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.

    Args:
        reserved_instances_listing_id(str): The ID of the Reserved Instance listing.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.reserved_instance.listing.cancel(
                ctx, reserved_instances_listing_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.reserved_instance.listing.cancel reserved_instances_listing_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="cancel_reserved_instances_listing",
        op_kwargs={"ReservedInstancesListingId": reserved_instances_listing_id},
    )


async def create(
    hub,
    ctx,
    client_token: str,
    instance_count: int,
    price_schedules: List,
    reserved_instances_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances, you can use the DescribeReservedInstances operation.  Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances cannot be sold.  The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances. To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved Instance listing, you can use the DescribeReservedInstancesListings operation. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.

    Args:
        client_token(str): Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate listings. For more information, see Ensuring Idempotency.
        instance_count(int): The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.
        price_schedules(List): A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.
        reserved_instances_id(str): The ID of the active Standard Reserved Instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.reserved_instance.listing.create(
                ctx,
                client_token=value,
                instance_count=value,
                price_schedules=value,
                reserved_instances_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.reserved_instance.listing.create client_token=value, instance_count=value, price_schedules=value, reserved_instances_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_reserved_instances_listing",
        op_kwargs={
            "ClientToken": client_token,
            "InstanceCount": instance_count,
            "PriceSchedules": price_schedules,
            "ReservedInstancesId": reserved_instances_id,
        },
    )


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    reserved_instances_id: str = None,
    reserved_instances_listing_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes your account's Reserved Instance listings in the Reserved Instance Marketplace. The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances. As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available for purchase. As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what you're searching for with what's available. The Marketplace first sells the lowest priced Reserved Instances to you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged based on the total price of all of the listings that you purchase. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.

    Args:
        filters(List, optional): One or more filters.    reserved-instances-id - The ID of the Reserved Instances.    reserved-instances-listing-id - The ID of the Reserved Instances listing.    status - The status of the Reserved Instance listing (pending | active | cancelled | closed).    status-message - The reason for the status.  . Defaults to None.
        reserved_instances_id(str, optional): One or more Reserved Instance IDs. Defaults to None.
        reserved_instances_listing_id(str, optional): One or more Reserved Instance listing IDs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.reserved_instance.listing.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.reserved_instance.listing.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_reserved_instances_listings",
        op_kwargs={
            "Filters": filters,
            "ReservedInstancesId": reserved_instances_id,
            "ReservedInstancesListingId": reserved_instances_listing_id,
        },
    )
