"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    offering_class: str = None,
    reserved_instances_ids: List = None,
    dry_run: bool = None,
    offering_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of the Reserved Instances that you purchased. For more information about Reserved Instances, see Reserved Instances in the Amazon EC2 User Guide.

    Args:
        filters(List, optional): One or more filters.    availability-zone - The Availability Zone where the Reserved Instance can be used.    duration - The duration of the Reserved Instance (one year or three years), in seconds (31536000 | 94608000).    end - The time when the Reserved Instance expires (for example, 2015-08-07T11:54:42.000Z).    fixed-price - The purchase price of the Reserved Instance (for example, 9800.0).    instance-type - The instance type that is covered by the reservation.    scope - The scope of the Reserved Instance (Region or Availability Zone).    product-description - The Reserved Instance product platform description. Instances that include (Amazon VPC) in the product platform description will only be displayed to EC2-Classic account holders and are for use with Amazon VPC (Linux/UNIX | Linux/UNIX (Amazon VPC) | SUSE Linux | SUSE Linux (Amazon VPC) | Red Hat Enterprise Linux | Red Hat Enterprise Linux (Amazon VPC) | Red Hat Enterprise Linux with HA (Amazon VPC) | Windows | Windows (Amazon VPC) | Windows with SQL Server Standard | Windows with SQL Server Standard (Amazon VPC) | Windows with SQL Server Web | Windows with SQL Server Web (Amazon VPC) | Windows with SQL Server Enterprise | Windows with SQL Server Enterprise (Amazon VPC)).    reserved-instances-id - The ID of the Reserved Instance.    start - The time at which the Reserved Instance purchase request was placed (for example, 2014-08-07T11:54:42.000Z).    state - The state of the Reserved Instance (payment-pending | active | payment-failed | retired).    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.    usage-price - The usage price of the Reserved Instance, per hour (for example, 0.84).  . Defaults to None.
        offering_class(str, optional): Describes whether the Reserved Instance is Standard or Convertible. Defaults to None.
        reserved_instances_ids(List, optional): One or more Reserved Instance IDs. Default: Describes all your Reserved Instances, or only those otherwise specified. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        offering_type(str, optional): The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only have access to the Medium Utilization Reserved Instance offering type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.reserved_instance.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.reserved_instance.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_reserved_instances",
        op_kwargs={
            "Filters": filters,
            "OfferingClass": offering_class,
            "ReservedInstancesIds": reserved_instances_ids,
            "DryRun": dry_run,
            "OfferingType": offering_type,
        },
    )


async def modify(
    hub,
    ctx,
    reserved_instances_ids: List,
    target_configurations: List,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the Availability Zone, instance count, instance type, or network platform (EC2-Classic or EC2-VPC) of your Reserved Instances. The Reserved Instances to be modified must be identical, except for Availability Zone, network platform, and instance type. For more information, see Modifying Reserved Instances in the Amazon EC2 User Guide.

    Args:
        reserved_instances_ids(List): The IDs of the Reserved Instances to modify.
        client_token(str, optional): A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more information, see Ensuring Idempotency. Defaults to None.
        target_configurations(List): The configuration settings for the Reserved Instances to modify.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.reserved_instance.init.modify(
                ctx, reserved_instances_ids=value, target_configurations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.reserved_instance.init.modify reserved_instances_ids=value, target_configurations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_reserved_instances",
        op_kwargs={
            "ReservedInstancesIds": reserved_instances_ids,
            "ClientToken": client_token,
            "TargetConfigurations": target_configurations,
        },
    )
