"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(
    hub,
    ctx,
    reserved_instance_ids: List,
    dry_run: bool = None,
    target_configurations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts the Convertible Reserved Instance exchange quote described in the GetReservedInstancesExchangeQuote call.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        reserved_instance_ids(List): The IDs of the Convertible Reserved Instances to exchange for another Convertible Reserved Instance of the same or higher value.
        target_configurations(List, optional): The configuration of the target Convertible Reserved Instance to exchange for your current Convertible Reserved Instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.reserved_instance.exchange_quote.accept(
                ctx, reserved_instance_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.reserved_instance.exchange_quote.accept reserved_instance_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="accept_reserved_instances_exchange_quote",
        op_kwargs={
            "DryRun": dry_run,
            "ReservedInstanceIds": reserved_instance_ids,
            "TargetConfigurations": target_configurations,
        },
    )


async def get(
    hub,
    ctx,
    reserved_instance_ids: List,
    dry_run: bool = None,
    target_configurations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a quote and exchange information for exchanging one or more specified Convertible Reserved Instances for a new Convertible Reserved Instance. If the exchange cannot be performed, the reason is returned in the response. Use AcceptReservedInstancesExchangeQuote to perform the exchange.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        reserved_instance_ids(List): The IDs of the Convertible Reserved Instances to exchange.
        target_configurations(List, optional): The configuration of the target Convertible Reserved Instance to exchange for your current Convertible Reserved Instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.reserved_instance.exchange_quote.get(
                ctx, reserved_instance_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.reserved_instance.exchange_quote.get reserved_instance_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_reserved_instances_exchange_quote",
        op_kwargs={
            "DryRun": dry_run,
            "ReservedInstanceIds": reserved_instance_ids,
            "TargetConfigurations": target_configurations,
        },
    )
