"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    region_names: List = None,
    dry_run: bool = None,
    all_regions: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the Regions that are enabled for your account, or all Regions. For a list of the Regions supported by Amazon EC2, see  Regions and Endpoints. For information about enabling and disabling Regions for your account, see Managing AWS Regions in the AWS General Reference.

    Args:
        filters(List, optional): The filters.    endpoint - The endpoint of the Region (for example, ec2.us-east-1.amazonaws.com).    opt-in-status - The opt-in status of the Region (opt-in-not-required | opted-in | not-opted-in).    region-name - The name of the Region (for example, us-east-1).  . Defaults to None.
        region_names(List, optional): The names of the Regions. You can specify any Regions, whether they are enabled and disabled for your account. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        all_regions(bool, optional): Indicates whether to display all Regions, including Regions that are disabled for your account. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.region.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.region.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_regions",
        op_kwargs={
            "Filters": filters,
            "RegionNames": region_names,
            "DryRun": dry_run,
            "AllRegions": all_regions,
        },
    )
