"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(
    hub, ctx, reserved_instances_ids: List, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the queued purchases for the specified Reserved Instances.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        reserved_instances_ids(List): The IDs of the Reserved Instances.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.queued_reserved_instance.delete_multiple(
                ctx, reserved_instances_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.queued_reserved_instance.delete_multiple reserved_instances_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_queued_reserved_instances",
        op_kwargs={"DryRun": dry_run, "ReservedInstancesIds": reserved_instances_ids},
    )
