"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def confirm(
    hub, ctx, instance_id: str, product_code: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Determines whether a product code is associated with an instance. This action can only be used by the owner of the product code. It is useful when a product code owner must verify whether another user's instance is eligible for support.

    Args:
        instance_id(str): The ID of the instance.
        product_code(str): The product code. This must be a product code that you own.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.product_instance.confirm(
                ctx, instance_id=value, product_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.product_instance.confirm instance_id=value, product_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="confirm_product_instance",
        op_kwargs={
            "InstanceId": instance_id,
            "ProductCode": product_code,
            "DryRun": dry_run,
        },
    )
