"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def assign(
    hub,
    ctx,
    network_interface_id: str,
    allow_reassignment: bool = None,
    private_ip_addresses: List = None,
    secondary_private_ip_address_count: int = None,
    ipv4_prefixes: List = None,
    ipv4_prefix_count: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Assigns one or more secondary private IP addresses to the specified network interface. You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses that you can assign to an instance varies by instance type. For information about instance types, see Instance Types in the Amazon Elastic Compute Cloud User Guide. For more information about Elastic IP addresses, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide. When you move a secondary private IP address to another network interface, any Elastic IP address that is associated with the IP address is also moved. Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to another, check network/interfaces/macs/mac/local-ipv4s in the instance metadata to confirm that the remapping is complete. You must specify either the IP addresses or the IP address count in the request. You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see Prefix Delegation in the Amazon Elastic Compute Cloud User Guide.

    Args:
        allow_reassignment(bool, optional): Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface. Defaults to None.
        network_interface_id(str): The ID of the network interface.
        private_ip_addresses(List, optional): One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses. If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range. Defaults to None.
        secondary_private_ip_address_count(int, optional): The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses. Defaults to None.
        ipv4_prefixes(List, optional): One or more IPv4 Prefix Delegation prefixes assigned to the network interface. You cannot use this option if you use the Ipv4PrefixCount option. Defaults to None.
        ipv4_prefix_count(int, optional): The number of IPv4 Prefix Delegation prefixes that AWS automatically assigns to the network interface. You cannot use this option if you use the Ipv4 Prefixes option. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.private_ip_address.assign(ctx, network_interface_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.private_ip_address.assign network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="assign_private_ip_addresses",
        op_kwargs={
            "AllowReassignment": allow_reassignment,
            "NetworkInterfaceId": network_interface_id,
            "PrivateIpAddresses": private_ip_addresses,
            "SecondaryPrivateIpAddressCount": secondary_private_ip_address_count,
            "Ipv4Prefixes": ipv4_prefixes,
            "Ipv4PrefixCount": ipv4_prefix_count,
        },
    )


async def unassign(
    hub,
    ctx,
    network_interface_id: str,
    private_ip_addresses: List = None,
    ipv4_prefixes: List = None,
) -> None:
    r"""
    **Autogenerated function**

    Unassigns one or more secondary private IP addresses, or IPv4 Prefix Delegation prefixes from a network interface.

    Args:
        network_interface_id(str): The ID of the network interface.
        private_ip_addresses(List, optional): The secondary private IP addresses to unassign from the network interface. You can specify this option multiple times to unassign more than one IP address. Defaults to None.
        ipv4_prefixes(List, optional): The IPv4 Prefix Delegation prefixes to unassign from the network interface. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.private_ip_address.unassign(ctx, network_interface_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.private_ip_address.unassign network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="unassign_private_ip_addresses",
        op_kwargs={
            "NetworkInterfaceId": network_interface_id,
            "PrivateIpAddresses": private_ip_addresses,
            "Ipv4Prefixes": ipv4_prefixes,
        },
    )
