"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    dry_run: bool = None,
    group_name: str = None,
    strategy: str = None,
    partition_count: int = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a placement group in which to launch instances. The strategy of the placement group determines how the instances are organized within the group.  A cluster placement group is a logical grouping of instances within a single Availability Zone that benefit from low network latency, high network throughput. A spread placement group places instances on distinct hardware. A partition placement group places groups of instances in different partitions, where instances in one partition do not share the same hardware with instances in another partition. For more information, see Placement groups in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        group_name(str, optional): A name for the placement group. Must be unique within the scope of your account for the Region. Constraints: Up to 255 ASCII characters. Defaults to None.
        strategy(str, optional): The placement strategy. Defaults to None.
        partition_count(int, optional): The number of partitions. Valid only when Strategy is set to partition. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the new placement group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.placement_group.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.placement_group.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_placement_group",
        op_kwargs={
            "DryRun": dry_run,
            "GroupName": group_name,
            "Strategy": strategy,
            "PartitionCount": partition_count,
            "TagSpecifications": tag_specifications,
        },
    )


async def delete(hub, ctx, group_name: str, dry_run: bool = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified placement group. You must terminate all instances in the placement group before you can delete the placement group. For more information, see Placement groups in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        group_name(str): The name of the placement group.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.placement_group.delete(ctx, group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.placement_group.delete group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_placement_group",
        op_kwargs={"DryRun": dry_run, "GroupName": group_name},
    )


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    dry_run: bool = None,
    group_names: List = None,
    group_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified placement groups or all of your placement groups. For more information, see Placement groups in the Amazon EC2 User Guide.

    Args:
        filters(List, optional): The filters.    group-name - The name of the placement group.    state - The state of the placement group (pending | available | deleting | deleted).    strategy - The strategy of the placement group (cluster | spread | partition).    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.  . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        group_names(List, optional): The names of the placement groups. Default: Describes all your placement groups, or only those otherwise specified. Defaults to None.
        group_ids(List, optional): The IDs of the placement groups. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.placement_group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.placement_group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_placement_groups",
        op_kwargs={
            "Filters": filters,
            "DryRun": dry_run,
            "GroupNames": group_names,
            "GroupIds": group_ids,
        },
    )
