"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    network_interface_id: str,
    permission: str,
    aws_account_id: str = None,
    aws_service: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an instance in their account. You can grant permission to a single Amazon Web Services account only, and only one account at a time.

    Args:
        network_interface_id(str): The ID of the network interface.
        aws_account_id(str, optional): The Amazon Web Services account ID. Defaults to None.
        aws_service(str, optional): The Amazon Web Service. Currently not supported. Defaults to None.
        permission(str): The type of permission to grant.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.permission.create(
                ctx, network_interface_id=value, permission=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.permission.create network_interface_id=value, permission=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_network_interface_permission",
        op_kwargs={
            "NetworkInterfaceId": network_interface_id,
            "AwsAccountId": aws_account_id,
            "AwsService": aws_service,
            "Permission": permission,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub,
    ctx,
    network_interface_permission_id: str,
    force: bool = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a permission for a network interface. By default, you cannot delete the permission if the account for which you're removing the permission has attached the network interface to an instance. However, you can force delete the permission, regardless of any attachment.

    Args:
        network_interface_permission_id(str): The ID of the network interface permission.
        force(bool, optional): Specify true to remove the permission even if the network interface is attached to an instance. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.permission.delete(
                ctx, network_interface_permission_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.permission.delete network_interface_permission_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_network_interface_permission",
        op_kwargs={
            "NetworkInterfacePermissionId": network_interface_permission_id,
            "Force": force,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    network_interface_permission_ids: List = None,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the permissions for your network interfaces.

    Args:
        network_interface_permission_ids(List, optional): One or more network interface permission IDs. Defaults to None.
        filters(List, optional): One or more filters.    network-interface-permission.network-interface-permission-id - The ID of the permission.    network-interface-permission.network-interface-id - The ID of the network interface.    network-interface-permission.aws-account-id - The Amazon Web Services account ID.    network-interface-permission.aws-service - The Amazon Web Service.    network-interface-permission.permission - The type of permission (INSTANCE-ATTACH | EIP-ASSOCIATE).  . Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. If this parameter is not specified, up to 50 results are returned by default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.permission.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.permission.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_network_interface_permissions",
        op_kwargs={
            "NetworkInterfacePermissionIds": network_interface_permission_ids,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
