"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(
    hub,
    ctx,
    device_index: int,
    instance_id: str,
    network_interface_id: str,
    dry_run: bool = None,
    network_card_index: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Attaches a network interface to an instance.

    Args:
        device_index(int): The index of the device for the network interface attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_id(str): The ID of the instance.
        network_interface_id(str): The ID of the network interface.
        network_card_index(int, optional): The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.init.attach(
                ctx, device_index=value, instance_id=value, network_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.init.attach device_index=value, instance_id=value, network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="attach_network_interface",
        op_kwargs={
            "DeviceIndex": device_index,
            "DryRun": dry_run,
            "InstanceId": instance_id,
            "NetworkInterfaceId": network_interface_id,
            "NetworkCardIndex": network_card_index,
        },
    )


async def create(
    hub,
    ctx,
    subnet_id: str,
    description: str = None,
    dry_run: bool = None,
    groups: List = None,
    ipv6_address_count: int = None,
    ipv6_addresses: List = None,
    private_ip_address: str = None,
    private_ip_addresses: List = None,
    secondary_private_ip_address_count: int = None,
    ipv4_prefixes: List = None,
    ipv4_prefix_count: int = None,
    ipv6_prefixes: List = None,
    ipv6_prefix_count: int = None,
    interface_type: str = None,
    tag_specifications: List = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a network interface in the specified subnet. For more information about network interfaces, see Elastic Network Interfaces in the Amazon Virtual Private Cloud User Guide.

    Args:
        description(str, optional): A description for the network interface. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        groups(List, optional): The IDs of one or more security groups. Defaults to None.
        ipv6_address_count(int, optional): The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses. If your subnet has the AssignIpv6AddressOnCreation attribute set to true, you can specify 0 to override this setting. Defaults to None.
        ipv6_addresses(List, optional): One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if you're specifying a number of IPv6 addresses. Defaults to None.
        private_ip_address(str, optional): The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot indicate any IP addresses specified in privateIpAddresses as primary (only one IP address can be designated as primary). Defaults to None.
        private_ip_addresses(List, optional): One or more private IPv4 addresses. Defaults to None.
        secondary_private_ip_address_count(int, optional): The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using privateIpAddresses. The number of IP addresses you can assign to a network interface varies by instance type. For more information, see IP Addresses Per ENI Per Instance Type in the Amazon Virtual Private Cloud User Guide. Defaults to None.
        ipv4_prefixes(List, optional): One or moreIPv4 Prefix Delegation prefixes assigned to the network interface. You cannot use this option if you use the Ipv4PrefixCount option. Defaults to None.
        ipv4_prefix_count(int, optional): The number of IPv4 Prefix Delegation prefixes that AWS automatically assigns to the network interface. You cannot use this option if you use the Ipv4 Prefixes option. Defaults to None.
        ipv6_prefixes(List, optional): One or moreIPv6 Prefix Delegation prefixes assigned to the network interface. You cannot use this option if you use the Ipv6PrefixCount option. Defaults to None.
        ipv6_prefix_count(int, optional): The number of IPv6 Prefix Delegation prefixes that AWS automatically assigns to the network interface. You cannot use this option if you use the Ipv6Prefixes option. Defaults to None.
        interface_type(str, optional): Indicates the type of network interface. To create an Elastic Fabric Adapter (EFA), specify efa. For more information, see  Elastic Fabric Adapter in the Amazon Elastic Compute Cloud User Guide. To create a trunk network interface, specify efa. For more information, see  Network interface trunking in the Amazon Elastic Compute Cloud User Guide. Defaults to None.
        subnet_id(str): The ID of the subnet to associate with the network interface.
        tag_specifications(List, optional): The tags to apply to the new network interface. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.init.create(ctx, subnet_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.init.create subnet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_network_interface",
        op_kwargs={
            "Description": description,
            "DryRun": dry_run,
            "Groups": groups,
            "Ipv6AddressCount": ipv6_address_count,
            "Ipv6Addresses": ipv6_addresses,
            "PrivateIpAddress": private_ip_address,
            "PrivateIpAddresses": private_ip_addresses,
            "SecondaryPrivateIpAddressCount": secondary_private_ip_address_count,
            "Ipv4Prefixes": ipv4_prefixes,
            "Ipv4PrefixCount": ipv4_prefix_count,
            "Ipv6Prefixes": ipv6_prefixes,
            "Ipv6PrefixCount": ipv6_prefix_count,
            "InterfaceType": interface_type,
            "SubnetId": subnet_id,
            "TagSpecifications": tag_specifications,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, network_interface_id: str, dry_run: bool = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified network interface. You must detach the network interface before you can delete it.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        network_interface_id(str): The ID of the network interface.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.init.delete(
                ctx, network_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.init.delete network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_network_interface",
        op_kwargs={"DryRun": dry_run, "NetworkInterfaceId": network_interface_id},
    )


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    dry_run: bool = None,
    network_interface_ids: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your network interfaces.

    Args:
        filters(List, optional): One or more filters.    addresses.private-ip-address - The private IPv4 addresses associated with the network interface.    addresses.primary - Whether the private IPv4 address is the primary IP address associated with the network interface.     addresses.association.public-ip - The association ID returned when the network interface was associated with the Elastic IP address (IPv4).    addresses.association.owner-id - The owner ID of the addresses associated with the network interface.    association.association-id - The association ID returned when the network interface was associated with an IPv4 address.    association.allocation-id - The allocation ID returned when you allocated the Elastic IP address (IPv4) for your network interface.    association.ip-owner-id - The owner of the Elastic IP address (IPv4) associated with the network interface.    association.public-ip - The address of the Elastic IP address (IPv4) bound to the network interface.    association.public-dns-name - The public DNS name for the network interface (IPv4).    attachment.attachment-id - The ID of the interface attachment.    attachment.attach-time - The time that the network interface was attached to an instance.    attachment.delete-on-termination - Indicates whether the attachment is deleted when an instance is terminated.    attachment.device-index - The device index to which the network interface is attached.    attachment.instance-id - The ID of the instance to which the network interface is attached.    attachment.instance-owner-id - The owner ID of the instance to which the network interface is attached.    attachment.status - The status of the attachment (attaching | attached | detaching | detached).    availability-zone - The Availability Zone of the network interface.    description - The description of the network interface.    group-id - The ID of a security group associated with the network interface.    group-name - The name of a security group associated with the network interface.    ipv6-addresses.ipv6-address - An IPv6 address associated with the network interface.    mac-address - The MAC address of the network interface.    network-interface-id - The ID of the network interface.    owner-id - The Amazon Web Services account ID of the network interface owner.    private-ip-address - The private IPv4 address or addresses of the network interface.    private-dns-name - The private DNS name of the network interface (IPv4).    requester-id - The alias or Amazon Web Services account ID of the principal or service that created the network interface.    requester-managed - Indicates whether the network interface is being managed by an Amazon Web Service (for example, Amazon Web Services Management Console, Auto Scaling, and so on).    source-dest-check - Indicates whether the network interface performs source/destination checking. A value of true means checking is enabled, and false means checking is disabled. The value must be false for the network interface to perform network address translation (NAT) in your VPC.     status - The status of the network interface. If the network interface is not attached to an instance, the status is available; if a network interface is attached to an instance the status is in-use.    subnet-id - The ID of the subnet for the network interface.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.    vpc-id - The ID of the VPC for the network interface.  . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        network_interface_ids(List, optional): One or more network interface IDs. Default: Describes all your network interfaces. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results. You cannot specify this parameter and the network interface IDs parameter in the same request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_network_interfaces",
        op_kwargs={
            "Filters": filters,
            "DryRun": dry_run,
            "NetworkInterfaceIds": network_interface_ids,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def detach(
    hub, ctx, attachment_id: str, dry_run: bool = None, force: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Detaches a network interface from an instance.

    Args:
        attachment_id(str): The ID of the attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        force(bool, optional): Specifies whether to force a detachment.    Use the Force parameter only as a last resort to detach a network interface from a failed instance.    If you use the Force parameter to detach a network interface, you might not be able to attach a different network interface to the same index on the instance without first stopping and starting the instance.   If you force the detachment of a network interface, the instance metadata might not get updated. This means that the attributes associated with the detached network interface might still be visible. The instance metadata will get updated when you stop and start the instance.   . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.init.detach(ctx, attachment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.init.detach attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="detach_network_interface",
        op_kwargs={"AttachmentId": attachment_id, "DryRun": dry_run, "Force": force},
    )
