"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub, ctx, network_interface_id: str, attribute: str = None, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a network interface attribute. You can specify only one attribute at a time.

    Args:
        attribute(str, optional): The attribute of the network interface. This parameter is required. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        network_interface_id(str): The ID of the network interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.attribute.describe(
                ctx, network_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.attribute.describe network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_network_interface_attribute",
        op_kwargs={
            "Attribute": attribute,
            "DryRun": dry_run,
            "NetworkInterfaceId": network_interface_id,
        },
    )


async def modify(
    hub,
    ctx,
    network_interface_id: str,
    attachment: Dict = None,
    description: Dict = None,
    dry_run: bool = None,
    groups: List = None,
    source_dest_check: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Modifies the specified network interface attribute. You can specify only one attribute at a time. You can use this action to attach and detach security groups from an existing EC2 instance.

    Args:
        attachment(Dict, optional): Information about the interface attachment. If modifying the 'delete on termination' attribute, you must specify the ID of the interface attachment. Defaults to None.
        description(Dict, optional): A description for the network interface. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        groups(List, optional): Changes the security groups for the network interface. The new set of groups you specify replaces the current set. You must specify at least one group, even if it's just the default security group in the VPC. You must specify the ID of the security group, not the name. Defaults to None.
        network_interface_id(str): The ID of the network interface.
        source_dest_check(Dict, optional): Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives. If the value is true, source/destination checks are enabled; otherwise, they are disabled. The default value is true. You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.attribute.modify(
                ctx, network_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.attribute.modify network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_network_interface_attribute",
        op_kwargs={
            "Attachment": attachment,
            "Description": description,
            "DryRun": dry_run,
            "Groups": groups,
            "NetworkInterfaceId": network_interface_id,
            "SourceDestCheck": source_dest_check,
        },
    )


async def reset(
    hub,
    ctx,
    network_interface_id: str,
    dry_run: bool = None,
    source_dest_check: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Resets a network interface attribute. You can specify only one attribute at a time.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        network_interface_id(str): The ID of the network interface.
        source_dest_check(str, optional): The source/destination checking attribute. Resets the value to true. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.interface.attribute.reset(
                ctx, network_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.interface.attribute.reset network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="reset_network_interface_attribute",
        op_kwargs={
            "DryRun": dry_run,
            "NetworkInterfaceId": network_interface_id,
            "SourceDestCheck": source_dest_check,
        },
    )
