"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, network_insights_analysis_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified network insights analysis.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        network_insights_analysis_id(str): The ID of the network insights analysis.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.insight.analysis.delete(
                ctx, network_insights_analysis_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.insight.analysis.delete network_insights_analysis_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_network_insights_analysis",
        op_kwargs={
            "DryRun": dry_run,
            "NetworkInsightsAnalysisId": network_insights_analysis_id,
        },
    )


async def start(
    hub,
    ctx,
    network_insights_path_id: str,
    client_token: str,
    filter_in_arns: List = None,
    dry_run: bool = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts analyzing the specified path. If the path is reachable, the operation returns the shortest feasible path.

    Args:
        network_insights_path_id(str): The ID of the path.
        filter_in_arns(List, optional): The Amazon Resource Names (ARN) of the resources that the path must traverse. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        tag_specifications(List, optional): The tags to apply. Defaults to None.
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.insight.analysis.start(
                ctx, network_insights_path_id=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.insight.analysis.start network_insights_path_id=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="start_network_insights_analysis",
        op_kwargs={
            "NetworkInsightsPathId": network_insights_path_id,
            "FilterInArns": filter_in_arns,
            "DryRun": dry_run,
            "TagSpecifications": tag_specifications,
            "ClientToken": client_token,
        },
    )
