"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    network_insights_analysis_ids: List = None,
    network_insights_path_id: str = None,
    analysis_start_time: str = None,
    analysis_end_time: str = None,
    filters: List = None,
    max_results: int = None,
    dry_run: bool = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your network insights analyses.

    Args:
        network_insights_analysis_ids(List, optional): The ID of the network insights analyses. You must specify either analysis IDs or a path ID. Defaults to None.
        network_insights_path_id(str, optional): The ID of the path. You must specify either a path ID or analysis IDs. Defaults to None.
        analysis_start_time(str, optional): The time when the network insights analyses started. Defaults to None.
        analysis_end_time(str, optional): The time when the network insights analyses ended. Defaults to None.
        filters(List, optional): The filters. The following are possible values:   PathFound - A Boolean value that indicates whether a feasible path is found.   Status - The status of the analysis (running | succeeded | failed).  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.insight.analyse.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.insight.analyse.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_network_insights_analyses",
        op_kwargs={
            "NetworkInsightsAnalysisIds": network_insights_analysis_ids,
            "NetworkInsightsPathId": network_insights_path_id,
            "AnalysisStartTime": analysis_start_time,
            "AnalysisEndTime": analysis_end_time,
            "Filters": filters,
            "MaxResults": max_results,
            "DryRun": dry_run,
            "NextToken": next_token,
        },
    )
