"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    egress: bool,
    network_acl_id: str,
    protocol: str,
    rule_action: str,
    rule_number: int,
    cidr_block: str = None,
    dry_run: bool = None,
    icmp_type_code: Dict = None,
    ipv6_cidr_block: str = None,
    port_range: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules. We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing ones without having to renumber the rules. After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old one. For more information about network ACLs, see Network ACLs in the Amazon Virtual Private Cloud User Guide.

    Args:
        cidr_block(str, optional): The IPv4 network range to allow or deny, in CIDR notation (for example 172.16.0.0/24). We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        egress(bool): Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).
        icmp_type_code(Dict, optional): ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block. Defaults to None.
        ipv6_cidr_block(str, optional): The IPv6 network range to allow or deny, in CIDR notation (for example 2001:db8:1234:1a00::/64). Defaults to None.
        network_acl_id(str): The ID of the network ACL.
        port_range(Dict, optional): TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP). Defaults to None.
        protocol(str): The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.
        rule_action(str): Indicates whether to allow or deny the traffic that matches the rule.
        rule_number(int): The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number. Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.acl.entry.create(
                ctx,
                egress=value,
                network_acl_id=value,
                protocol=value,
                rule_action=value,
                rule_number=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.acl.entry.create egress=value, network_acl_id=value, protocol=value, rule_action=value, rule_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_network_acl_entry",
        op_kwargs={
            "CidrBlock": cidr_block,
            "DryRun": dry_run,
            "Egress": egress,
            "IcmpTypeCode": icmp_type_code,
            "Ipv6CidrBlock": ipv6_cidr_block,
            "NetworkAclId": network_acl_id,
            "PortRange": port_range,
            "Protocol": protocol,
            "RuleAction": rule_action,
            "RuleNumber": rule_number,
        },
    )


async def delete(
    hub, ctx, egress: bool, network_acl_id: str, rule_number: int, dry_run: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified ingress or egress entry (rule) from the specified network ACL.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        egress(bool): Indicates whether the rule is an egress rule.
        network_acl_id(str): The ID of the network ACL.
        rule_number(int): The rule number of the entry to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.acl.entry.delete(
                ctx, egress=value, network_acl_id=value, rule_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.acl.entry.delete egress=value, network_acl_id=value, rule_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_network_acl_entry",
        op_kwargs={
            "DryRun": dry_run,
            "Egress": egress,
            "NetworkAclId": network_acl_id,
            "RuleNumber": rule_number,
        },
    )


async def replace(
    hub,
    ctx,
    egress: bool,
    network_acl_id: str,
    protocol: str,
    rule_action: str,
    rule_number: int,
    cidr_block: str = None,
    dry_run: bool = None,
    icmp_type_code: Dict = None,
    ipv6_cidr_block: str = None,
    port_range: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Replaces an entry (rule) in a network ACL. For more information, see Network ACLs in the Amazon Virtual Private Cloud User Guide.

    Args:
        cidr_block(str, optional): The IPv4 network range to allow or deny, in CIDR notation (for example 172.16.0.0/24). Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        egress(bool): Indicates whether to replace the egress rule. Default: If no value is specified, we replace the ingress rule.
        icmp_type_code(Dict, optional): ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block. Defaults to None.
        ipv6_cidr_block(str, optional): The IPv6 network range to allow or deny, in CIDR notation (for example 2001:bd8:1234:1a00::/64). Defaults to None.
        network_acl_id(str): The ID of the ACL.
        port_range(Dict, optional): TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP). Defaults to None.
        protocol(str): The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.
        rule_action(str): Indicates whether to allow or deny the traffic that matches the rule.
        rule_number(int): The rule number of the entry to replace.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.acl.entry.replace(
                ctx,
                egress=value,
                network_acl_id=value,
                protocol=value,
                rule_action=value,
                rule_number=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.acl.entry.replace egress=value, network_acl_id=value, protocol=value, rule_action=value, rule_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="replace_network_acl_entry",
        op_kwargs={
            "CidrBlock": cidr_block,
            "DryRun": dry_run,
            "Egress": egress,
            "IcmpTypeCode": icmp_type_code,
            "Ipv6CidrBlock": ipv6_cidr_block,
            "NetworkAclId": network_acl_id,
            "PortRange": port_range,
            "Protocol": protocol,
            "RuleAction": rule_action,
            "RuleNumber": rule_number,
        },
    )
