"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def replace(
    hub, ctx, association_id: str, network_acl_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Changes which network ACL a subnet is associated with. By default when you create a subnet, it's automatically associated with the default network ACL. For more information, see Network ACLs in the Amazon Virtual Private Cloud User Guide. This is an idempotent operation.

    Args:
        association_id(str): The ID of the current association between the original network ACL and the subnet.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        network_acl_id(str): The ID of the new network ACL to associate with the subnet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.network.acl.association.replace(
                ctx, association_id=value, network_acl_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.network.acl.association.replace association_id=value, network_acl_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="replace_network_acl_association",
        op_kwargs={
            "AssociationId": association_id,
            "DryRun": dry_run,
            "NetworkAclId": network_acl_id,
        },
    )
