"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    subnet_id: str,
    allocation_id: str = None,
    client_token: str = None,
    dry_run: bool = None,
    tag_specifications: List = None,
    connectivity_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or a private NAT gateway. With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that instances in a private subnet can connect to the internet. With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks. For more information, see NAT gateways in the Amazon Virtual Private Cloud User Guide.

    Args:
        allocation_id(str, optional): [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency. Constraint: Maximum 64 ASCII characters. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        subnet_id(str): The subnet in which to create the NAT gateway.
        tag_specifications(List, optional): The tags to assign to the NAT gateway. Defaults to None.
        connectivity_type(str, optional): Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.nat_gateway.create(ctx, subnet_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.nat_gateway.create subnet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_nat_gateway",
        op_kwargs={
            "AllocationId": allocation_id,
            "ClientToken": client_token,
            "DryRun": dry_run,
            "SubnetId": subnet_id,
            "TagSpecifications": tag_specifications,
            "ConnectivityType": connectivity_type,
        },
    )


async def delete(hub, ctx, nat_gateway_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your route tables.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        nat_gateway_id(str): The ID of the NAT gateway.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.nat_gateway.delete(ctx, nat_gateway_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.nat_gateway.delete nat_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_nat_gateway",
        op_kwargs={"DryRun": dry_run, "NatGatewayId": nat_gateway_id},
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    filter_: List = None,
    max_results: int = None,
    nat_gateway_ids: List = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your NAT gateways.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filter_(List, optional): One or more filters.    nat-gateway-id - The ID of the NAT gateway.    state - The state of the NAT gateway (pending | failed | available | deleting | deleted).    subnet-id - The ID of the subnet in which the NAT gateway resides.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.    vpc-id - The ID of the VPC in which the NAT gateway resides.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        nat_gateway_ids(List, optional): One or more NAT gateway IDs. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.nat_gateway.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.nat_gateway.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_nat_gateways",
        op_kwargs={
            "DryRun": dry_run,
            "Filter": filter_,
            "MaxResults": max_results,
            "NatGatewayIds": nat_gateway_ids,
            "NextToken": next_token,
        },
    )
