"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    dry_run: bool = None,
    max_results: int = None,
    next_token: str = None,
    public_ips: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your account.

    Args:
        filters(List, optional): One or more filters.    moving-status - The status of the Elastic IP address (MovingToVpc | RestoringToClassic).  . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned NextToken value. This value can be between 5 and 1000; if MaxResults is given a value outside of this range, an error is returned. Default: If no value is provided, the default is 1000. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        public_ips(List, optional): One or more Elastic IP addresses. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.moving_address.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.moving_address.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_moving_addresses",
        op_kwargs={
            "Filters": filters,
            "DryRun": dry_run,
            "MaxResults": max_results,
            "NextToken": next_token,
            "PublicIps": public_ips,
        },
    )
