"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def restore(
    hub,
    ctx,
    prefix_list_id: str,
    previous_version: int,
    current_version: int,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Restores the entries from a previous version of a managed prefix list to a new version of the prefix list.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        prefix_list_id(str): The ID of the prefix list.
        previous_version(int): The version to restore.
        current_version(int): The current version number for the prefix list.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.managed_prefix_list_.version.restore(
                ctx, prefix_list_id=value, previous_version=value, current_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.managed_prefix_list_.version.restore prefix_list_id=value, previous_version=value, current_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="restore_managed_prefix_list_version",
        op_kwargs={
            "DryRun": dry_run,
            "PrefixListId": prefix_list_id,
            "PreviousVersion": previous_version,
            "CurrentVersion": current_version,
        },
    )
