"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    prefix_list_name: str,
    max_entries: int,
    address_family: str,
    dry_run: bool = None,
    entries: List = None,
    tag_specifications: List = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and an optional description. You must specify the maximum number of entries for the prefix list. The maximum number of entries cannot be changed later.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        prefix_list_name(str): A name for the prefix list. Constraints: Up to 255 characters in length. The name cannot start with com.amazonaws.
        entries(List, optional): One or more entries for the prefix list. Defaults to None.
        max_entries(int): The maximum number of entries for the prefix list.
        tag_specifications(List, optional): The tags to apply to the prefix list during creation. Defaults to None.
        address_family(str): The IP address type. Valid Values: IPv4 | IPv6 .
        client_token(str, optional): Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Constraints: Up to 255 UTF-8 characters in length. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.managed_prefix_list_.init.create(
                ctx, prefix_list_name=value, max_entries=value, address_family=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.managed_prefix_list_.init.create prefix_list_name=value, max_entries=value, address_family=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_managed_prefix_list",
        op_kwargs={
            "DryRun": dry_run,
            "PrefixListName": prefix_list_name,
            "Entries": entries,
            "MaxEntries": max_entries,
            "TagSpecifications": tag_specifications,
            "AddressFamily": address_family,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, prefix_list_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified managed prefix list. You must first remove all references to the prefix list in your resources.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        prefix_list_id(str): The ID of the prefix list.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.managed_prefix_list_.init.delete(ctx, prefix_list_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.managed_prefix_list_.init.delete prefix_list_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_managed_prefix_list",
        op_kwargs={"DryRun": dry_run, "PrefixListId": prefix_list_id},
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    prefix_list_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes your managed prefix lists and any Amazon Web Services-managed prefix lists. To view the entries for your prefix list, use GetManagedPrefixListEntries.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filters(List, optional): One or more filters.    owner-id - The ID of the prefix list owner.    prefix-list-id - The ID of the prefix list.    prefix-list-name - The name of the prefix list.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        prefix_list_ids(List, optional): One or more prefix list IDs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.managed_prefix_list_.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.managed_prefix_list_.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_managed_prefix_lists",
        op_kwargs={
            "DryRun": dry_run,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "PrefixListIds": prefix_list_ids,
        },
    )


async def modify(
    hub,
    ctx,
    prefix_list_id: str,
    dry_run: bool = None,
    current_version: int = None,
    prefix_list_name: str = None,
    add_entries: List = None,
    remove_entries: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified managed prefix list. Adding or removing entries in a prefix list creates a new version of the prefix list. Changing the name of the prefix list does not affect the version. If you specify a current version number that does not match the true current version number, the request fails.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        prefix_list_id(str): The ID of the prefix list.
        current_version(int, optional): The current version of the prefix list. Defaults to None.
        prefix_list_name(str, optional): A name for the prefix list. Defaults to None.
        add_entries(List, optional): One or more entries to add to the prefix list. Defaults to None.
        remove_entries(List, optional): One or more entries to remove from the prefix list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.managed_prefix_list_.init.modify(ctx, prefix_list_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.managed_prefix_list_.init.modify prefix_list_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_managed_prefix_list",
        op_kwargs={
            "DryRun": dry_run,
            "PrefixListId": prefix_list_id,
            "CurrentVersion": current_version,
            "PrefixListName": prefix_list_name,
            "AddEntries": add_entries,
            "RemoveEntries": remove_entries,
        },
    )
