"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    prefix_list_id: str,
    dry_run: bool = None,
    target_version: int = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the entries for a specified managed prefix list.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        prefix_list_id(str): The ID of the prefix list.
        target_version(int, optional): The version of the prefix list for which to return the entries. The default is the current version. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.managed_prefix_list_.entry.get_all(
                ctx, prefix_list_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.managed_prefix_list_.entry.get_all prefix_list_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_managed_prefix_list_entries",
        op_kwargs={
            "DryRun": dry_run,
            "PrefixListId": prefix_list_id,
            "TargetVersion": target_version,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
