"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    local_gateway_route_table_id: str,
    vpc_id: str,
    tag_specifications: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified VPC with the specified local gateway route table.

    Args:
        local_gateway_route_table_id(str): The ID of the local gateway route table.
        vpc_id(str): The ID of the VPC.
        tag_specifications(List, optional): The tags to assign to the local gateway route table VPC association. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.local_gateway.route.table.vpc_association.create(
                ctx, local_gateway_route_table_id=value, vpc_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.local_gateway.route.table.vpc_association.create local_gateway_route_table_id=value, vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_local_gateway_route_table_vpc_association",
        op_kwargs={
            "LocalGatewayRouteTableId": local_gateway_route_table_id,
            "VpcId": vpc_id,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, local_gateway_route_table_vpc_association_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified association between a VPC and local gateway route table.

    Args:
        local_gateway_route_table_vpc_association_id(str): The ID of the association.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.local_gateway.route.table.vpc_association.delete(
                ctx, local_gateway_route_table_vpc_association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.local_gateway.route.table.vpc_association.delete local_gateway_route_table_vpc_association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_local_gateway_route_table_vpc_association",
        op_kwargs={
            "LocalGatewayRouteTableVpcAssociationId": local_gateway_route_table_vpc_association_id,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    local_gateway_route_table_vpc_association_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified associations between VPCs and local gateway route tables.

    Args:
        local_gateway_route_table_vpc_association_ids(List, optional): The IDs of the associations. Defaults to None.
        filters(List, optional): One or more filters.    local-gateway-id - The ID of a local gateway.    local-gateway-route-table-id - The ID of the local gateway route table.    local-gateway-route-table-vpc-association-id - The ID of the association.    state - The state of the association.    vpc-id - The ID of the VPC.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.local_gateway.route.table.vpc_association.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.local_gateway.route.table.vpc_association.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_local_gateway_route_table_vpc_associations",
        op_kwargs={
            "LocalGatewayRouteTableVpcAssociationIds": local_gateway_route_table_vpc_association_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )
