"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    destination_cidr_block: str,
    local_gateway_route_table_id: str,
    local_gateway_virtual_interface_group_id: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a static route for the specified local gateway route table.

    Args:
        destination_cidr_block(str): The CIDR range used for destination matches. Routing decisions are based on the most specific match.
        local_gateway_route_table_id(str): The ID of the local gateway route table.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        local_gateway_virtual_interface_group_id(str): The ID of the virtual interface group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.local_gateway.route.init.create(
                ctx,
                destination_cidr_block=value,
                local_gateway_route_table_id=value,
                local_gateway_virtual_interface_group_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.local_gateway.route.init.create destination_cidr_block=value, local_gateway_route_table_id=value, local_gateway_virtual_interface_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_local_gateway_route",
        op_kwargs={
            "DestinationCidrBlock": destination_cidr_block,
            "LocalGatewayRouteTableId": local_gateway_route_table_id,
            "DryRun": dry_run,
            "LocalGatewayVirtualInterfaceGroupId": local_gateway_virtual_interface_group_id,
        },
    )


async def delete(
    hub,
    ctx,
    destination_cidr_block: str,
    local_gateway_route_table_id: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified route from the specified local gateway route table.

    Args:
        destination_cidr_block(str): The CIDR range for the route. This must match the CIDR for the route exactly.
        local_gateway_route_table_id(str): The ID of the local gateway route table.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.local_gateway.route.init.delete(
                ctx, destination_cidr_block=value, local_gateway_route_table_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.local_gateway.route.init.delete destination_cidr_block=value, local_gateway_route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_local_gateway_route",
        op_kwargs={
            "DestinationCidrBlock": destination_cidr_block,
            "LocalGatewayRouteTableId": local_gateway_route_table_id,
            "DryRun": dry_run,
        },
    )


async def search(
    hub,
    ctx,
    local_gateway_route_table_id: str,
    filters: List,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for routes in the specified local gateway route table.

    Args:
        local_gateway_route_table_id(str): The ID of the local gateway route table.
        filters(List): One or more filters.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.local_gateway.route.init.search(
                ctx, local_gateway_route_table_id=value, filters=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.local_gateway.route.init.search local_gateway_route_table_id=value, filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="search_local_gateway_routes",
        op_kwargs={
            "LocalGatewayRouteTableId": local_gateway_route_table_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )
