"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    launch_template_data: Dict,
    dry_run: bool = None,
    client_token: str = None,
    launch_template_id: str = None,
    launch_template_name: str = None,
    source_version: str = None,
    version_description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version for a launch template. You can specify an existing version of launch template from which to base the new version. Launch template versions are numbered in the order in which they are created. You cannot specify, change, or replace the numbering of launch template versions. For more information, see Managing launch template versionsin the Amazon Elastic Compute Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Constraint: Maximum 128 ASCII characters. Defaults to None.
        launch_template_id(str, optional): The ID of the launch template. You must specify either the launch template ID or launch template name in the request. Defaults to None.
        launch_template_name(str, optional): The name of the launch template. You must specify either the launch template ID or launch template name in the request. Defaults to None.
        source_version(str, optional): The version number of the launch template version on which to base the new version. The new version inherits the same launch parameters as the source version, except for parameters that you specify in LaunchTemplateData. Snapshots applied to the block device mapping are ignored when creating a new version unless they are explicitly included. Defaults to None.
        version_description(str, optional): A description for the version of the launch template. Defaults to None.
        launch_template_data(Dict): The information for the launch template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.launch_template.version.create(
                ctx, launch_template_data=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.launch_template.version.create launch_template_data=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_launch_template_version",
        op_kwargs={
            "DryRun": dry_run,
            "ClientToken": client_token,
            "LaunchTemplateId": launch_template_id,
            "LaunchTemplateName": launch_template_name,
            "SourceVersion": source_version,
            "VersionDescription": version_description,
            "LaunchTemplateData": launch_template_data,
        },
    )


async def delete_multiple(
    hub,
    ctx,
    versions: List,
    dry_run: bool = None,
    launch_template_id: str = None,
    launch_template_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more versions of a launch template. You cannot delete the default version of a launch template; you must first assign a different version as the default. If the default version is the only version for the launch template, you must delete the entire launch template using DeleteLaunchTemplate.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        launch_template_id(str, optional): The ID of the launch template. You must specify either the launch template ID or launch template name in the request. Defaults to None.
        launch_template_name(str, optional): The name of the launch template. You must specify either the launch template ID or launch template name in the request. Defaults to None.
        versions(List): The version numbers of one or more launch template versions to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.launch_template.version.delete_multiple(ctx, versions=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.launch_template.version.delete_multiple versions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_launch_template_versions",
        op_kwargs={
            "DryRun": dry_run,
            "LaunchTemplateId": launch_template_id,
            "LaunchTemplateName": launch_template_name,
            "Versions": versions,
        },
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    launch_template_id: str = None,
    launch_template_name: str = None,
    versions: List = None,
    min_version: str = None,
    max_version: str = None,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more versions of a specified launch template. You can describe all versions, individual versions, or a range of versions. You can also describe all the latest versions or all the default versions of all the launch templates in your account.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        launch_template_id(str, optional): The ID of the launch template. To describe one or more versions of a specified launch template, you must specify either the launch template ID or the launch template name in the request. To describe all the latest or default launch template versions in your account, you must omit this parameter. Defaults to None.
        launch_template_name(str, optional): The name of the launch template. To describe one or more versions of a specified launch template, you must specify either the launch template ID or the launch template name in the request. To describe all the latest or default launch template versions in your account, you must omit this parameter. Defaults to None.
        versions(List, optional): One or more versions of the launch template. Valid values depend on whether you are describing a specified launch template (by ID or name) or all launch templates in your account. To describe one or more versions of a specified launch template, valid values are $Latest, $Default, and numbers. To describe all launch templates in your account that are defined as the latest version, the valid value is $Latest. To describe all launch templates in your account that are defined as the default version, the valid value is $Default. You can specify $Latest and $Default in the same call. You cannot specify numbers. Defaults to None.
        min_version(str, optional): The version number after which to describe launch template versions. Defaults to None.
        max_version(str, optional): The version number up to which to describe launch template versions. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. This value can be between 1 and 200. Defaults to None.
        filters(List, optional): One or more filters.    create-time - The time the launch template version was created.    ebs-optimized - A boolean that indicates whether the instance is optimized for Amazon EBS I/O.    iam-instance-profile - The ARN of the IAM instance profile.    image-id - The ID of the AMI.    instance-type - The instance type.    is-default-version - A boolean that indicates whether the launch template version is the default version.    kernel-id - The kernel ID.    ram-disk-id - The RAM disk ID.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.launch_template.version.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.launch_template.version.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_launch_template_versions",
        op_kwargs={
            "DryRun": dry_run,
            "LaunchTemplateId": launch_template_id,
            "LaunchTemplateName": launch_template_name,
            "Versions": versions,
            "MinVersion": min_version,
            "MaxVersion": max_version,
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
        },
    )
