"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    launch_template_name: str,
    launch_template_data: Dict,
    dry_run: bool = None,
    client_token: str = None,
    version_description: str = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a launch template. A launch template contains the parameters to launch an instance. When you launch an instance using RunInstances, you can specify a launch template instead of providing the launch parameters in the request. For more information, see Launching an instance from a launch templatein the Amazon Elastic Compute Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Constraint: Maximum 128 ASCII characters. Defaults to None.
        launch_template_name(str): A name for the launch template.
        version_description(str, optional): A description for the first version of the launch template. Defaults to None.
        launch_template_data(Dict): The information for the launch template.
        tag_specifications(List, optional): The tags to apply to the launch template during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.launch_template.init.create(
                ctx, launch_template_name=value, launch_template_data=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.launch_template.init.create launch_template_name=value, launch_template_data=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_launch_template",
        op_kwargs={
            "DryRun": dry_run,
            "ClientToken": client_token,
            "LaunchTemplateName": launch_template_name,
            "VersionDescription": version_description,
            "LaunchTemplateData": launch_template_data,
            "TagSpecifications": tag_specifications,
        },
    )


async def delete(
    hub,
    ctx,
    dry_run: bool = None,
    launch_template_id: str = None,
    launch_template_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a launch template. Deleting a launch template deletes all of its versions.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        launch_template_id(str, optional): The ID of the launch template. You must specify either the launch template ID or launch template name in the request. Defaults to None.
        launch_template_name(str, optional): The name of the launch template. You must specify either the launch template ID or launch template name in the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.launch_template.init.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.launch_template.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_launch_template",
        op_kwargs={
            "DryRun": dry_run,
            "LaunchTemplateId": launch_template_id,
            "LaunchTemplateName": launch_template_name,
        },
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    launch_template_ids: List = None,
    launch_template_names: List = None,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more launch templates.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        launch_template_ids(List, optional): One or more launch template IDs. Defaults to None.
        launch_template_names(List, optional): One or more launch template names. Defaults to None.
        filters(List, optional): One or more filters.    create-time - The time the launch template was created.    launch-template-name - The name of the launch template.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. This value can be between 1 and 200. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.launch_template.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.launch_template.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_launch_templates",
        op_kwargs={
            "DryRun": dry_run,
            "LaunchTemplateIds": launch_template_ids,
            "LaunchTemplateNames": launch_template_names,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def modify(
    hub,
    ctx,
    dry_run: bool = None,
    client_token: str = None,
    launch_template_id: str = None,
    launch_template_name: str = None,
    default_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a launch template. You can specify which version of the launch template to set as the default version. When launching an instance, the default version applies when a launch template version is not specified.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Constraint: Maximum 128 ASCII characters. Defaults to None.
        launch_template_id(str, optional): The ID of the launch template. You must specify either the launch template ID or launch template name in the request. Defaults to None.
        launch_template_name(str, optional): The name of the launch template. You must specify either the launch template ID or launch template name in the request. Defaults to None.
        default_version(str, optional): The version number of the launch template to set as the default version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.launch_template.init.modify(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.launch_template.init.modify
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_launch_template",
        op_kwargs={
            "DryRun": dry_run,
            "ClientToken": client_token,
            "LaunchTemplateId": launch_template_id,
            "LaunchTemplateName": launch_template_name,
            "DefaultVersion": default_version,
        },
    )
