"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def create(
    hub, ctx, key_name: str, dry_run: bool = None, tag_specifications: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is returned as an unencrypted PEM encoded PKCS#1 private key. If a key with the specified name already exists, Amazon EC2 returns an error. You can have up to five thousand key pairs per Region. The key pair returned to you is available only in the Region in which you create it. If you prefer, you can create your own key pair using a third-party tool and upload it to any Region using ImportKeyPair. For more information, see Key Pairs in the Amazon Elastic Compute Cloud User Guide.

    Args:
        key_name(str): A unique name for the key pair. Constraints: Up to 255 ASCII characters.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the new key pair. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.key_pair.create(ctx, key_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.key_pair.create key_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_key_pair",
        op_kwargs={
            "KeyName": key_name,
            "DryRun": dry_run,
            "TagSpecifications": tag_specifications,
        },
    )


async def delete(
    hub, ctx, key_name: str = None, key_pair_id: str = None, dry_run: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified key pair, by removing the public key from Amazon EC2.

    Args:
        key_name(str, optional): The name of the key pair. Defaults to None.
        key_pair_id(str, optional): The ID of the key pair. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.key_pair.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.key_pair.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_key_pair",
        op_kwargs={"KeyName": key_name, "KeyPairId": key_pair_id, "DryRun": dry_run},
    )


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    key_names: List = None,
    key_pair_ids: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified key pairs or all of your key pairs. For more information about key pairs, see Key Pairs in the Amazon Elastic Compute Cloud User Guide.

    Args:
        filters(List, optional): The filters.    key-pair-id - The ID of the key pair.    fingerprint - The fingerprint of the key pair.    key-name - The name of the key pair.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.  . Defaults to None.
        key_names(List, optional): The key pair names. Default: Describes all of your key pairs. Defaults to None.
        key_pair_ids(List, optional): The IDs of the key pairs. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.key_pair.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.key_pair.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_key_pairs",
        op_kwargs={
            "Filters": filters,
            "KeyNames": key_names,
            "KeyPairIds": key_pair_ids,
            "DryRun": dry_run,
        },
    )


async def import_(
    hub,
    ctx,
    key_name: str,
    public_key_material: bytes,
    dry_run: bool = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Imports the public key from an RSA key pair that you created with a third-party tool. Compare this with CreateKeyPair, in which Amazon Web Services creates the key pair and gives the keys to you (Amazon Web Services keeps a copy of the public key). With ImportKeyPair, you create the key pair and give Amazon Web Services just the public key. The private key is never transferred between you and Amazon Web Services. For more information about key pairs, see Key Pairs in the Amazon Elastic Compute Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        key_name(str): A unique name for the key pair.
        public_key_material(bytes): The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is performed for you.
        tag_specifications(List, optional): The tags to apply to the imported key pair. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.key_pair.import(ctx, key_name=value, public_key_material=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.key_pair.import key_name=value, public_key_material=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="import_key_pair",
        op_kwargs={
            "DryRun": dry_run,
            "KeyName": key_name,
            "PublicKeyMaterial": public_key_material,
            "TagSpecifications": tag_specifications,
        },
    )
