"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def assign(
    hub,
    ctx,
    network_interface_id: str,
    ipv6_address_count: int = None,
    ipv6_addresses: List = None,
    ipv6_prefix_count: int = None,
    ipv6_prefixes: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6 addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private IPv4 addresses, and the limit varies per instance type. For information, see IP Addresses Per Network Interface Per Instance Type in the Amazon Elastic Compute Cloud User Guide. You must specify either the IPv6 addresses or the IPv6 address count in the request.  You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see Prefix Delegation in the Amazon Elastic Compute Cloud User Guide.

    Args:
        ipv6_address_count(int, optional): The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6 addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses. Defaults to None.
        ipv6_addresses(List, optional): One or more specific IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a number of IPv6 addresses. Defaults to None.
        ipv6_prefix_count(int, optional): The number of IPv6 Prefix Delegation prefixes that AWS automatically assigns to the network interface. You cannot use this option if you use the Ipv6Prefixes option. Defaults to None.
        ipv6_prefixes(List, optional): One or more IPv6 Prefix Delegation prefixes assigned to the network interface. You cannot use this option if you use the Ipv6PrefixCount option. Defaults to None.
        network_interface_id(str): The ID of the network interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.ipv6.address.assign(ctx, network_interface_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.ipv6.address.assign network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="assign_ipv6_addresses",
        op_kwargs={
            "Ipv6AddressCount": ipv6_address_count,
            "Ipv6Addresses": ipv6_addresses,
            "Ipv6PrefixCount": ipv6_prefix_count,
            "Ipv6Prefixes": ipv6_prefixes,
            "NetworkInterfaceId": network_interface_id,
        },
    )


async def unassign(
    hub,
    ctx,
    network_interface_id: str,
    ipv6_addresses: List = None,
    ipv6_prefixes: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Unassigns one or more IPv6 addresses IPv4 Prefix Delegation prefixes from a network interface.

    Args:
        ipv6_addresses(List, optional): The IPv6 addresses to unassign from the network interface. Defaults to None.
        ipv6_prefixes(List, optional): One or moreIPv6 Prefix Delegation prefixes to unassign from the network interface. Defaults to None.
        network_interface_id(str): The ID of the network interface.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.ipv6.address.unassign(ctx, network_interface_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.ipv6.address.unassign network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="unassign_ipv6_addresses",
        op_kwargs={
            "Ipv6Addresses": ipv6_addresses,
            "Ipv6Prefixes": ipv6_prefixes,
            "NetworkInterfaceId": network_interface_id,
        },
    )
