"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(
    hub, ctx, internet_gateway_id: str, vpc_id: str, dry_run: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet and the VPC. For more information about your VPC and internet gateway, see the Amazon Virtual Private Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        internet_gateway_id(str): The ID of the internet gateway.
        vpc_id(str): The ID of the VPC.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.internet_gateway.attach(
                ctx, internet_gateway_id=value, vpc_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.internet_gateway.attach internet_gateway_id=value, vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="attach_internet_gateway",
        op_kwargs={
            "DryRun": dry_run,
            "InternetGatewayId": internet_gateway_id,
            "VpcId": vpc_id,
        },
    )


async def create(
    hub, ctx, tag_specifications: List = None, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using AttachInternetGateway. For more information about your VPC and internet gateway, see the Amazon Virtual Private Cloud User Guide.

    Args:
        tag_specifications(List, optional): The tags to assign to the internet gateway. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.internet_gateway.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.internet_gateway.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_internet_gateway",
        op_kwargs={"TagSpecifications": tag_specifications, "DryRun": dry_run},
    )


async def delete(hub, ctx, internet_gateway_id: str, dry_run: bool = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete it.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        internet_gateway_id(str): The ID of the internet gateway.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.internet_gateway.delete(ctx, internet_gateway_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.internet_gateway.delete internet_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_internet_gateway",
        op_kwargs={"DryRun": dry_run, "InternetGatewayId": internet_gateway_id},
    )


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    dry_run: bool = None,
    internet_gateway_ids: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your internet gateways.

    Args:
        filters(List, optional): One or more filters.    attachment.state - The current state of the attachment between the gateway and the VPC (available). Present only if a VPC is attached.    attachment.vpc-id - The ID of an attached VPC.    internet-gateway-id - The ID of the Internet gateway.    owner-id - The ID of the Amazon Web Services account that owns the internet gateway.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        internet_gateway_ids(List, optional): One or more internet gateway IDs. Default: Describes all your internet gateways. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.internet_gateway.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.internet_gateway.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_internet_gateways",
        op_kwargs={
            "Filters": filters,
            "DryRun": dry_run,
            "InternetGatewayIds": internet_gateway_ids,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def detach(
    hub, ctx, internet_gateway_id: str, vpc_id: str, dry_run: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Detaches an internet gateway from a VPC, disabling connectivity between the internet and the VPC. The VPC must not contain any running instances with Elastic IP addresses or public IPv4 addresses.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        internet_gateway_id(str): The ID of the internet gateway.
        vpc_id(str): The ID of the VPC.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.internet_gateway.detach(
                ctx, internet_gateway_id=value, vpc_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.internet_gateway.detach internet_gateway_id=value, vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="detach_internet_gateway",
        op_kwargs={
            "DryRun": dry_run,
            "InternetGatewayId": internet_gateway_id,
            "VpcId": vpc_id,
        },
    )
