"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    filters: List = None,
    instance_ids: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
    include_all_instances: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the status of the specified instances or all of your instances. By default, only running instances are described, unless you specifically indicate to return the status of all instances. Instance status includes the following components:    Status checks - Amazon EC2 performs status checks on running EC2 instances to identify hardware and software issues. For more information, see Status checks for your instances and Troubleshooting instances with failed status checks in the Amazon EC2 User Guide.    Scheduled events - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances related to hardware issues, software updates, or system maintenance. For more information, see Scheduled events for your instances in the Amazon EC2 User Guide.    Instance state - You can manage your instances from the moment you launch them through their termination. For more information, see Instance lifecycle in the Amazon EC2 User Guide.

    Args:
        filters(List, optional): The filters.    availability-zone - The Availability Zone of the instance.    event.code - The code for the scheduled event (instance-reboot | system-reboot | system-maintenance | instance-retirement | instance-stop).    event.description - A description of the event.    event.instance-event-id - The ID of the event whose date and time you are modifying.    event.not-after - The latest end time for the scheduled event (for example, 2014-09-15T17:15:20.000Z).    event.not-before - The earliest start time for the scheduled event (for example, 2014-09-15T17:15:20.000Z).    event.not-before-deadline - The deadline for starting the event (for example, 2014-09-15T17:15:20.000Z).    instance-state-code - The code for the instance state, as a 16-bit unsigned integer. The high byte is used for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).    instance-state-name - The state of the instance (pending | running | shutting-down | terminated | stopping | stopped).    instance-status.reachability - Filters on instance status where the name is reachability (passed | failed | initializing | insufficient-data).    instance-status.status - The status of the instance (ok | impaired | initializing | insufficient-data | not-applicable).    system-status.reachability - Filters on system status where the name is reachability (passed | failed | initializing | insufficient-data).    system-status.status - The system status of the instance (ok | impaired | initializing | insufficient-data | not-applicable).  . Defaults to None.
        instance_ids(List, optional): The instance IDs. Default: Describes all your instances. Constraints: Maximum 100 explicitly specified instance IDs. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        include_all_instances(bool, optional): When true, includes the health status for all instances. When false, includes the health status for running instances only. Default: false . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.status.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.status.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_instance_status",
        op_kwargs={
            "Filters": filters,
            "InstanceIds": instance_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
            "IncludeAllInstances": include_all_instances,
        },
    )


async def report(
    hub,
    ctx,
    instances: List,
    reason_codes: List,
    status: str,
    description: str = None,
    dry_run: bool = None,
    end_time: str = None,
    start_time: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Submits feedback about the status of an instance. The instance must be in the running state. If your experience with the instance differs from the instance status returned by DescribeInstanceStatus, use ReportInstanceStatus to report your experience with the instance. Amazon EC2 collects this information to improve the accuracy of status checks. Use of this action does not change the value returned by DescribeInstanceStatus.

    Args:
        description(str, optional): Descriptive text about the health state of your instance. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        end_time(str, optional): The time at which the reported instance health state ended. Defaults to None.
        instances(List): The instances.
        reason_codes(List): The reason codes that describe the health state of your instance.    instance-stuck-in-state: My instance is stuck in a state.    unresponsive: My instance is unresponsive.    not-accepting-credentials: My instance is not accepting my credentials.    password-not-available: A password is not available for my instance.    performance-network: My instance is experiencing performance problems that I believe are network related.    performance-instance-store: My instance is experiencing performance problems that I believe are related to the instance stores.    performance-ebs-volume: My instance is experiencing performance problems that I believe are related to an EBS volume.    performance-other: My instance is experiencing performance problems.    other: [explain using the description parameter]  .
        start_time(str, optional): The time at which the reported instance health state began. Defaults to None.
        status(str): The status of all instances listed.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.status.report(
                ctx, instances=value, reason_codes=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.status.report instances=value, reason_codes=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="report_instance_status",
        op_kwargs={
            "Description": description,
            "DryRun": dry_run,
            "EndTime": end_time,
            "Instances": instances,
            "ReasonCodes": reason_codes,
            "StartTime": start_time,
            "Status": status,
        },
    )
