"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(
    hub,
    ctx,
    instance_id: str,
    affinity: str = None,
    group_name: str = None,
    host_id: str = None,
    tenancy: str = None,
    partition_number: int = None,
    host_resource_group_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the placement attributes for a specified instance. You can do the following:   Modify the affinity between an instance and a Dedicated Host. When affinity is set to host and the instance is not associated with a specific Dedicated Host, the next time the instance is launched, it is automatically associated with the host on which it lands. If the instance is restarted or rebooted, this relationship persists.   Change the Dedicated Host with which an instance is associated.   Change the instance tenancy of an instance from host to dedicated, or from dedicated to host.   Move an instance to or from a placement group.   At least one attribute for affinity, host ID, tenancy, or placement group name must be specified in the request. Affinity and tenancy can be modified in the same request. To modify the host ID, tenancy, placement group, or partition for an instance, the instance must be in the stopped state.

    Args:
        affinity(str, optional): The affinity setting for the instance. Defaults to None.
        group_name(str, optional): The name of the placement group in which to place the instance. For spread placement groups, the instance must have a tenancy of default. For cluster and partition placement groups, the instance must have a tenancy of default or dedicated. To remove an instance from a placement group, specify an empty string (""). Defaults to None.
        host_id(str, optional): The ID of the Dedicated Host with which to associate the instance. Defaults to None.
        instance_id(str): The ID of the instance that you are modifying.
        tenancy(str, optional): The tenancy for the instance. Defaults to None.
        partition_number(int, optional): Reserved for future use. Defaults to None.
        host_resource_group_arn(str, optional): The ARN of the host resource group in which to place the instance. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.placement.modify(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.placement.modify instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_instance_placement",
        op_kwargs={
            "Affinity": affinity,
            "GroupName": group_name,
            "HostId": host_id,
            "InstanceId": instance_id,
            "Tenancy": tenancy,
            "PartitionNumber": partition_number,
            "HostResourceGroupArn": host_resource_group_arn,
        },
    )
