"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    export_to_s3_task: Dict,
    instance_id: str,
    target_environment: str,
    description: str = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Exports a running or stopped instance to an Amazon S3 bucket. For information about the supported operating systems, image formats, and known limitations for the types of instances you can export, see Exporting an instance as a VM Using VM Import/Export in the VM Import/Export User Guide.

    Args:
        description(str, optional): A description for the conversion task or the resource being exported. The maximum length is 255 characters. Defaults to None.
        export_to_s3_task(Dict): The format and location for an export instance task.
        instance_id(str): The ID of the instance.
        target_environment(str): The target virtualization environment.
        tag_specifications(List, optional): The tags to apply to the export instance task during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.export_task.create(
                ctx, export_to_s3_task=value, instance_id=value, target_environment=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.export_task.create export_to_s3_task=value, instance_id=value, target_environment=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_instance_export_task",
        op_kwargs={
            "Description": description,
            "ExportToS3Task": export_to_s3_task,
            "InstanceId": instance_id,
            "TargetEnvironment": target_environment,
            "TagSpecifications": tag_specifications,
        },
    )
