"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    instance_event_window_id: str,
    association_target: Dict,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs, or tags) can be specified with an event window. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_event_window_id(str): The ID of the event window.
        association_target(Dict): One or more targets associated with the specified event window.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.event.window.associate(
                ctx, instance_event_window_id=value, association_target=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.event.window.associate instance_event_window_id=value, association_target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="associate_instance_event_window",
        op_kwargs={
            "DryRun": dry_run,
            "InstanceEventWindowId": instance_event_window_id,
            "AssociationTarget": association_target,
        },
    )


async def create(
    hub,
    ctx,
    dry_run: bool = None,
    name: str = None,
    time_ranges: List = None,
    cron_expression: str = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an event window in which scheduled events for the associated Amazon EC2 instances can run. You can define either a set of time ranges or a cron expression when creating the event window, but not both. All event window times are in UTC. You can create up to 200 event windows per Amazon Web Services Region. When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with it. To ensure that the event window can be used, you must associate one or more targets with it by using the AssociateInstanceEventWindow API.  Event windows are applicable only for scheduled events that stop, reboot, or terminate instances. Event windows are not applicable for:   Expedited scheduled events and network maintenance events.    Unscheduled maintenance such as AutoRecovery and unplanned reboots.    For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        name(str, optional): The name of the event window. Defaults to None.
        time_ranges(List, optional): The time range for the event window. If you specify a time range, you can't specify a cron expression. Defaults to None.
        cron_expression(str, optional): The cron expression for the event window, for example, * 0-4,20-23 * * 1,5. If you specify a cron expression, you can't specify a time range. Constraints:   Only hour and day of the week values are supported.   For day of the week values, you can specify either integers 0 through 6, or alternative single values SUN through SAT.   The minute, month, and year must be specified by *.   The hour value must be one or a multiple range, for example, 0-4 or 0-4,20-23.   Each hour range must be >= 2 hours, for example, 0-2 or 20-23.   The event window must be >= 4 hours. The combined total time ranges in the event window must be >= 4 hours.   For more information about cron expressions, see cron on the Wikipedia website. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the event window. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.event.window.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.event.window.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_instance_event_window",
        op_kwargs={
            "DryRun": dry_run,
            "Name": name,
            "TimeRanges": time_ranges,
            "CronExpression": cron_expression,
            "TagSpecifications": tag_specifications,
        },
    )


async def delete(
    hub,
    ctx,
    instance_event_window_id: str,
    dry_run: bool = None,
    force_delete: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified event window. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        force_delete(bool, optional): Specify true to force delete the event window. Use the force delete parameter if the event window is currently associated with targets. Defaults to None.
        instance_event_window_id(str): The ID of the event window.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.event.window.delete(
                ctx, instance_event_window_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.event.window.delete instance_event_window_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_instance_event_window",
        op_kwargs={
            "DryRun": dry_run,
            "ForceDelete": force_delete,
            "InstanceEventWindowId": instance_event_window_id,
        },
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    instance_event_window_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified event windows or all event windows. If you specify event window IDs, the output includes information for only the specified event windows. If you specify filters, the output includes information for only those event windows that meet the filter criteria. If you do not specify event windows IDs or filters, the output includes information for all event windows, which can affect performance. We recommend that you use pagination to ensure that the operation returns quickly and successfully.  For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_event_window_ids(List, optional): The IDs of the event windows. Defaults to None.
        filters(List, optional): One or more filters.    dedicated-host-id - The event windows associated with the specified Dedicated Host ID.    event-window-name - The event windows associated with the specified names.     instance-id - The event windows associated with the specified instance ID.    instance-tag - The event windows associated with the specified tag and value.    instance-tag-key - The event windows associated with the specified tag key, regardless of the value.    instance-tag-value - The event windows associated with the specified tag value, regardless of the key.    tag:<key> - The key/value combination of a tag assigned to the event window. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value CMX, specify tag:Owner for the filter name and CMX for the filter value.     tag-key - The key of a tag assigned to the event window. Use this filter to find all event windows that have a tag with a specific key, regardless of the tag value.     tag-value - The value of a tag assigned to the event window. Use this filter to find all event windows that have a tag with a specific value, regardless of the tag key.   . Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. This value can be between 20 and 500. You cannot specify this parameter and the event window IDs parameter in the same call. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.event.window.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.event.window.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_instance_event_windows",
        op_kwargs={
            "DryRun": dry_run,
            "InstanceEventWindowIds": instance_event_window_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def disassociate(
    hub,
    ctx,
    instance_event_window_id: str,
    association_target: Dict,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates one or more targets from an event window. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_event_window_id(str): The ID of the event window.
        association_target(Dict): One or more targets to disassociate from the specified event window.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.event.window.disassociate(
                ctx, instance_event_window_id=value, association_target=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.event.window.disassociate instance_event_window_id=value, association_target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disassociate_instance_event_window",
        op_kwargs={
            "DryRun": dry_run,
            "InstanceEventWindowId": instance_event_window_id,
            "AssociationTarget": association_target,
        },
    )


async def modify(
    hub,
    ctx,
    instance_event_window_id: str,
    dry_run: bool = None,
    name: str = None,
    time_ranges: List = None,
    cron_expression: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified event window. You can define either a set of time ranges or a cron expression when modifying the event window, but not both. To modify the targets associated with the event window, use the AssociateInstanceEventWindow and DisassociateInstanceEventWindow API. If Amazon Web Services has already scheduled an event, modifying an event window won't change the time of the scheduled event. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        name(str, optional): The name of the event window. Defaults to None.
        instance_event_window_id(str): The ID of the event window.
        time_ranges(List, optional): The time ranges of the event window. Defaults to None.
        cron_expression(str, optional): The cron expression of the event window, for example, * 0-4,20-23 * * 1,5. Constraints:   Only hour and day of the week values are supported.   For day of the week values, you can specify either integers 0 through 6, or alternative single values SUN through SAT.   The minute, month, and year must be specified by *.   The hour value must be one or a multiple range, for example, 0-4 or 0-4,20-23.   Each hour range must be >= 2 hours, for example, 0-2 or 20-23.   The event window must be >= 4 hours. The combined total time ranges in the event window must be >= 4 hours.   For more information about cron expressions, see cron on the Wikipedia website. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.event.window.modify(
                ctx, instance_event_window_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.event.window.modify instance_event_window_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_instance_event_window",
        op_kwargs={
            "DryRun": dry_run,
            "Name": name,
            "InstanceEventWindowId": instance_event_window_id,
            "TimeRanges": time_ranges,
            "CronExpression": cron_expression,
        },
    )
