"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(
    hub,
    ctx,
    instance_id: str,
    instance_event_id: str,
    not_before: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the start time for a scheduled Amazon EC2 instance event.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_id(str): The ID of the instance with the scheduled event.
        instance_event_id(str): The ID of the event whose date and time you are modifying.
        not_before(str): The new date and time when the event will take place.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.event.start_time.modify(
                ctx, instance_id=value, instance_event_id=value, not_before=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.event.start_time.modify instance_id=value, instance_event_id=value, not_before=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_instance_event_start_time",
        op_kwargs={
            "DryRun": dry_run,
            "InstanceId": instance_id,
            "InstanceEventId": instance_event_id,
            "NotBefore": not_before,
        },
    )
