"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(
    hub, ctx, dry_run: bool = None, instance_tag_attribute: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    c Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event notifications for resources in the Region.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_tag_attribute(Dict, optional): Information about the tag keys to deregister. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.event.notification_attribute.deregister(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.event.notification_attribute.deregister
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="deregister_instance_event_notification_attributes",
        op_kwargs={"DryRun": dry_run, "InstanceTagAttribute": instance_tag_attribute},
    )


async def describe_all(hub, ctx, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the tag keys that are registered to appear in scheduled event notifications for resources in the current Region.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.event.notification_attribute.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.event.notification_attribute.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_instance_event_notification_attributes",
        op_kwargs={"DryRun": dry_run},
    )


async def register(
    hub, ctx, dry_run: bool = None, instance_tag_attribute: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Registers a set of tag keys to include in scheduled event notifications for your resources.  To remove tags, use .

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_tag_attribute(Dict, optional): Information about the tag keys to register. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.event.notification_attribute.register(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.event.notification_attribute.register
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="register_instance_event_notification_attributes",
        op_kwargs={"DryRun": dry_run, "InstanceTagAttribute": instance_tag_attribute},
    )
