"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    filters: List = None,
    instance_ids: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the credit option for CPU usage of the specified burstable performance instances. The credit options are standard and unlimited. If you do not specify an instance ID, Amazon EC2 returns burstable performance instances with the unlimited credit option, as well as instances that were previously configured as T2, T3, and T3a with the unlimited credit option. For example, if you resize a T2 instance, while it is configured as unlimited, to an M4 instance, Amazon EC2 returns the M4 instance. If you specify one or more instance IDs, Amazon EC2 returns the credit option (standard or unlimited) of those instances. If you specify an instance ID that is not valid, such as an instance that is not a burstable performance instance, an error is returned. Recently terminated instances might appear in the returned results. This interval is usually less than one hour. If an Availability Zone is experiencing a service disruption and you specify instance IDs in the affected zone, or do not specify any instance IDs at all, the call fails. If you specify only instance IDs in an unaffected zone, the call works normally. For more information, see Burstable performance instances in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filters(List, optional): The filters.    instance-id - The ID of the instance.  . Defaults to None.
        instance_ids(List, optional): The instance IDs. Default: Describes all your instances. Constraints: Maximum 1000 explicitly specified instance IDs. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.credit_specification.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.credit_specification.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_instance_credit_specifications",
        op_kwargs={
            "DryRun": dry_run,
            "Filters": filters,
            "InstanceIds": instance_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def modify(
    hub,
    ctx,
    instance_credit_specifications: List,
    dry_run: bool = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the credit option for CPU usage on a running or stopped burstable performance instance. The credit options are standard and unlimited. For more information, see Burstable performance instances in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more information, see Ensuring Idempotency. Defaults to None.
        instance_credit_specifications(List): Information about the credit option for CPU usage.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.credit_specification.modify(
                ctx, instance_credit_specifications=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.credit_specification.modify instance_credit_specifications=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_instance_credit_specification",
        op_kwargs={
            "DryRun": dry_run,
            "ClientToken": client_token,
            "InstanceCreditSpecifications": instance_credit_specifications,
        },
    )
