"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(
    hub,
    ctx,
    instance_id: str,
    capacity_reservation_specification: Dict,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the Capacity Reservation settings for a stopped instance. Use this action to configure an instance to target a specific Capacity Reservation, run in any open Capacity Reservation with matching attributes, or run On-Demand Instance capacity.

    Args:
        instance_id(str): The ID of the instance to be modified.
        capacity_reservation_specification(Dict): Information about the Capacity Reservation targeting option.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.capacity_reservation_attribute.modify(
                ctx, instance_id=value, capacity_reservation_specification=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.capacity_reservation_attribute.modify instance_id=value, capacity_reservation_specification=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_instance_capacity_reservation_attributes",
        op_kwargs={
            "InstanceId": instance_id,
            "CapacityReservationSpecification": capacity_reservation_specification,
            "DryRun": dry_run,
        },
    )
