"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub, ctx, attribute: str, instance_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid attribute values are: instanceType | kernel | ramdisk | userData | disableApiTermination | instanceInitiatedShutdownBehavior | rootDeviceName | blockDeviceMapping | productCodes | sourceDestCheck | groupSet | ebsOptimized | sriovNetSupport

    Args:
        attribute(str): The instance attribute. Note: The enaSupport attribute is not supported at this time.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_id(str): The ID of the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.attribute.describe(
                ctx, attribute=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.attribute.describe attribute=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_instance_attribute",
        op_kwargs={
            "Attribute": attribute,
            "DryRun": dry_run,
            "InstanceId": instance_id,
        },
    )


async def modify(
    hub,
    ctx,
    instance_id: str,
    source_dest_check: Dict = None,
    attribute: str = None,
    block_device_mappings: List = None,
    disable_api_termination: Dict = None,
    dry_run: bool = None,
    ebs_optimized: Dict = None,
    ena_support: Dict = None,
    groups: List = None,
    instance_initiated_shutdown_behavior: Dict = None,
    instance_type: Dict = None,
    kernel: Dict = None,
    ramdisk: Dict = None,
    sriov_net_support: Dict = None,
    user_data: Dict = None,
    value: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Modifies the specified attribute of the specified instance. You can specify only one attribute at a time.  Note: Using this action to change the security groups associated with an elastic network interface (ENI) attached to an instance in a VPC can result in an error if the instance has more than one ENI. To change the security groups associated with an ENI attached to an instance that has multiple ENIs, we recommend that you use the ModifyNetworkInterfaceAttribute action. To modify some attributes, the instance must be stopped. For more information, see Modifying attributes of a stopped instance in the Amazon EC2 User Guide.

    Args:
        source_dest_check(Dict, optional): Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives. If the value is true, source/destination checks are enabled; otherwise, they are disabled. The default value is true. You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls. Defaults to None.
        attribute(str, optional): The name of the attribute. Defaults to None.
        block_device_mappings(List, optional): Modifies the DeleteOnTermination attribute for volumes that are currently attached. The volume must be owned by the caller. If no value is specified for DeleteOnTermination, the default is true and the volume is deleted when the instance is terminated. To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the instance. For more information, see Updating the block device mapping when launching an instance in the Amazon EC2 User Guide. Defaults to None.
        disable_api_termination(Dict, optional): If the value is true, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. You cannot use this parameter for Spot Instances. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        ebs_optimized(Dict, optional): Specifies whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance. Defaults to None.
        ena_support(Dict, optional): Set to true to enable enhanced networking with ENA for the instance. This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable. Defaults to None.
        groups(List, optional): [EC2-VPC] Replaces the security groups of the instance with the specified security groups. You must specify at least one security group, even if it's just the default security group for the VPC. You must specify the security group ID, not the security group name. Defaults to None.
        instance_id(str): The ID of the instance.
        instance_initiated_shutdown_behavior(Dict, optional): Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown). Defaults to None.
        instance_type(Dict, optional): Changes the instance type to the specified value. For more information, see Instance types in the Amazon EC2 User Guide. If the instance type is not valid, the error returned is InvalidInstanceAttributeValue. Defaults to None.
        kernel(Dict, optional): Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see PV-GRUB. Defaults to None.
        ramdisk(Dict, optional): Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see PV-GRUB. Defaults to None.
        sriov_net_support(Dict, optional): Set to simple to enable enhanced networking with the Intel 82599 Virtual Function interface for the instance. There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time. This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable. Defaults to None.
        user_data(Dict, optional): Changes the instance's user data to the specified value. If you are using an Amazon Web Services SDK or command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. Defaults to None.
        value(str, optional): A new value for the attribute. Use only with the kernel, ramdisk, userData, disableApiTermination, or instanceInitiatedShutdownBehavior attribute. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.attribute.modify(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.attribute.modify instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_instance_attribute",
        op_kwargs={
            "SourceDestCheck": source_dest_check,
            "Attribute": attribute,
            "BlockDeviceMappings": block_device_mappings,
            "DisableApiTermination": disable_api_termination,
            "DryRun": dry_run,
            "EbsOptimized": ebs_optimized,
            "EnaSupport": ena_support,
            "Groups": groups,
            "InstanceId": instance_id,
            "InstanceInitiatedShutdownBehavior": instance_initiated_shutdown_behavior,
            "InstanceType": instance_type,
            "Kernel": kernel,
            "Ramdisk": ramdisk,
            "SriovNetSupport": sriov_net_support,
            "UserData": user_data,
            "Value": value,
        },
    )


async def reset(
    hub, ctx, attribute: str, instance_id: str, dry_run: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Resets an attribute of an instance to its default value. To reset the kernel or ramdisk, the instance must be in a stopped state. To reset the sourceDestCheck, the instance can be either running or stopped. The sourceDestCheck attribute controls whether source/destination checking is enabled. The default value is true, which means checking is enabled. This value must be false for a NAT instance to perform NAT. For more information, see NAT Instances in the Amazon VPC User Guide.

    Args:
        attribute(str): The attribute to reset.  You can only reset the following attributes: kernel | ramdisk | sourceDestCheck. To change an instance attribute, use ModifyInstanceAttribute. .
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_id(str): The ID of the instance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.instance.attribute.reset(
                ctx, attribute=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.instance.attribute.reset attribute=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="reset_instance_attribute",
        op_kwargs={
            "Attribute": attribute,
            "DryRun": dry_run,
            "InstanceId": instance_id,
        },
    )
