"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(
    hub,
    ctx,
    cancel_reason: str = None,
    dry_run: bool = None,
    import_task_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Cancels an in-process import virtual machine or import snapshot task.

    Args:
        cancel_reason(str, optional): The reason for canceling the task. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        import_task_id(str, optional): The ID of the import image or import snapshot task to be canceled. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.import_.task.cancel(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.import_.task.cancel
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="cancel_import_task",
        op_kwargs={
            "CancelReason": cancel_reason,
            "DryRun": dry_run,
            "ImportTaskId": import_task_id,
        },
    )
