"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    filters: List = None,
    import_task_ids: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Displays details about an import virtual machine or import snapshot tasks that are already created.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filters(List, optional): Filter tasks using the task-state filter and one of the following values: active, completed, deleting, or deleted. Defaults to None.
        import_task_ids(List, optional): The IDs of the import image tasks. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.
        next_token(str, optional): A token that indicates the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.import_.image_task.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.import_.image_task.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_import_image_tasks",
        op_kwargs={
            "DryRun": dry_run,
            "Filters": filters,
            "ImportTaskIds": import_task_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
