"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def copy(
    hub,
    ctx,
    name: str,
    source_image_id: str,
    source_region: str,
    client_token: str = None,
    description: str = None,
    encrypted: bool = None,
    kms_key_id: str = None,
    destination_outpost_arn: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a Region to an AWS Outpost. You can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy an AMI to another partition, see CreateStoreImageTask. To copy an AMI from one Region to another, specify the source Region using the SourceRegion parameter, and specify the destination Region using its endpoint. Copies of encrypted backing snapshots for the AMI are encrypted. Copies of unencrypted backing snapshots remain unencrypted, unless you set Encrypted during the copy operation. You cannot create an unencrypted copy of an encrypted backing snapshot. To copy an AMI from a Region to an Outpost, specify the source Region using the SourceRegion parameter, and specify the ARN of the destination Outpost using DestinationOutpostArn. Backing snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a different key that you specify in the request using KmsKeyId. Outposts do not support unencrypted snapshots. For more information,  Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide. For more information about the prerequisites and limits when copying an AMI, see Copying an AMI in the Amazon Elastic Compute Cloud User Guide.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference. Defaults to None.
        description(str, optional): A description for the new AMI in the destination Region. Defaults to None.
        encrypted(bool, optional): Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default CMK for EBS is used unless you specify a non-default AWS Key Management Service (AWS KMS) CMK using KmsKeyId. For more information, see Amazon EBS Encryption in the Amazon Elastic Compute Cloud User Guide. Defaults to None.
        kms_key_id(str, optional): The identifier of the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating encrypted volumes. If this parameter is not specified, your AWS managed CMK for EBS is used. If you specify a CMK, you must also set the encrypted state to true. You can specify a CMK using any of the following:   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.   Key alias. For example, alias/ExampleAlias.   Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.   Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.   AWS authenticates the CMK asynchronously. Therefore, if you specify an identifier that is not valid, the action can appear to complete, but eventually fails. The specified CMK must exist in the destination Region. Amazon EBS does not support asymmetric CMKs. Defaults to None.
        name(str): The name of the new AMI in the destination Region.
        source_image_id(str): The ID of the AMI to copy.
        source_region(str): The name of the Region that contains the AMI to copy.
        destination_outpost_arn(str, optional): The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. For more information, see  Copying AMIs from an AWS Region to an Outpost in the Amazon Elastic Compute Cloud User Guide. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.init.copy(ctx, name=value, source_image_id=value, source_region=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.init.copy name=value, source_image_id=value, source_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="copy_image",
        op_kwargs={
            "ClientToken": client_token,
            "Description": description,
            "Encrypted": encrypted,
            "KmsKeyId": kms_key_id,
            "Name": name,
            "SourceImageId": source_image_id,
            "SourceRegion": source_region,
            "DestinationOutpostArn": destination_outpost_arn,
            "DryRun": dry_run,
        },
    )


async def create(
    hub,
    ctx,
    instance_id: str,
    name: str,
    block_device_mappings: List = None,
    description: str = None,
    dry_run: bool = None,
    no_reboot: bool = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped. If you customized your instance with instance store volumes or EBS volumes in addition to the root device volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from this new AMI, the instance automatically launches with those additional volumes. For more information, see Creating Amazon EBS-Backed Linux AMIs in the Amazon Elastic Compute Cloud User Guide.

    Args:
        block_device_mappings(List, optional): The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes or snapshots. To create an AMI with encrypted snapshots, use the CopyImage action. Defaults to None.
        description(str, optional): A description for the new image. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_id(str): The ID of the instance.
        name(str): A name for the new image. Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_).
        no_reboot(bool, optional): By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the No Reboot option is set, Amazon EC2 doesn't shut down the instance before creating the image. When this option is used, file system integrity on the created image can't be guaranteed. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.   To tag the AMI, the value for ResourceType must be image.   To tag the snapshots that are created of the root volume and of other EBS volumes that are attached to the instance, the value for ResourceType must be snapshot. The same tag is applied to all of the snapshots that are created.   If you specify other values for ResourceType, the request fails. To tag an AMI or snapshot after it has been created, see CreateTags. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.init.create(ctx, instance_id=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.init.create instance_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_image",
        op_kwargs={
            "BlockDeviceMappings": block_device_mappings,
            "Description": description,
            "DryRun": dry_run,
            "InstanceId": instance_id,
            "Name": name,
            "NoReboot": no_reboot,
            "TagSpecifications": tag_specifications,
        },
    )


async def deregister(hub, ctx, image_id: str, dry_run: bool = None) -> None:
    r"""
    **Autogenerated function**

    Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances; however, it doesn't affect any instances that you've already launched from the AMI. You'll continue to incur usage costs for those instances until you terminate them. When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was created for the root volume of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn't affect the files that you uploaded to Amazon S3 when you created the AMI.

    Args:
        image_id(str): The ID of the AMI.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.init.deregister(ctx, image_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.init.deregister image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="deregister_image",
        op_kwargs={"ImageId": image_id, "DryRun": dry_run},
    )


async def describe_all(
    hub,
    ctx,
    executable_users: List = None,
    filters: List = None,
    image_ids: List = None,
    owners: List = None,
    include_deprecated: bool = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you. The images available to you include public images, private images that you own, and private images owned by other AWS accounts for which you have explicit launch permissions. Recently deregistered images appear in the returned results for a short interval and then return empty results. After all instances that reference a deregistered AMI are terminated, specifying the ID of the image will eventually return an error indicating that the AMI ID cannot be found.

    Args:
        executable_users(List, optional): Scopes the images by users with explicit launch permissions. Specify an AWS account ID, self (the sender of the request), or all (public AMIs). Defaults to None.
        filters(List, optional): The filters.    architecture - The image architecture (i386 | x86_64 | arm64).    block-device-mapping.delete-on-termination - A Boolean value that indicates whether the Amazon EBS volume is deleted on instance termination.    block-device-mapping.device-name - The device name specified in the block device mapping (for example, /dev/sdh or xvdh).    block-device-mapping.snapshot-id - The ID of the snapshot used for the EBS volume.    block-device-mapping.volume-size - The volume size of the EBS volume, in GiB.    block-device-mapping.volume-type - The volume type of the EBS volume (gp2 | io1 | io2 | st1 | sc1 | standard).    block-device-mapping.encrypted - A Boolean that indicates whether the EBS volume is encrypted.    description - The description of the image (provided during image creation).    ena-support - A Boolean that indicates whether enhanced networking with ENA is enabled.    hypervisor - The hypervisor type (ovm | xen).    image-id - The ID of the image.    image-type - The image type (machine | kernel | ramdisk).    is-public - A Boolean that indicates whether the image is public.    kernel-id - The kernel ID.    manifest-location - The location of the image manifest.    name - The name of the AMI (provided during image creation).    owner-alias - The owner alias (amazon | aws-marketplace). The valid aliases are defined in an Amazon-maintained list. This is not the AWS account alias that can be set using the IAM console. We recommend that you use the Owner request parameter instead of this filter.    owner-id - The AWS account ID of the owner. We recommend that you use the Owner request parameter instead of this filter.    platform - The platform. To only list Windows-based AMIs, use windows.    product-code - The product code.    product-code.type - The type of the product code (devpay | marketplace).    ramdisk-id - The RAM disk ID.    root-device-name - The device name of the root device volume (for example, /dev/sda1).    root-device-type - The type of the root device volume (ebs | instance-store).    state - The state of the image (available | pending | failed).    state-reason-code - The reason code for the state change.    state-reason-message - The message for the state change.    sriov-net-support - A value of simple indicates that enhanced networking with the Intel 82599 VF interface is enabled.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.    virtualization-type - The virtualization type (paravirtual | hvm).  . Defaults to None.
        image_ids(List, optional): The image IDs. Default: Describes all images available to you. Defaults to None.
        owners(List, optional): Scopes the results to images with the specified owners. You can specify a combination of AWS account IDs, self, amazon, and aws-marketplace. If you omit this parameter, the results include all images for which you have launch permissions, regardless of ownership. Defaults to None.
        include_deprecated(bool, optional): If true, all deprecated AMIs are included in the response. If false, no deprecated AMIs are included in the response. If no value is specified, the default value is false.  If you are the AMI owner, all deprecated AMIs appear in the response regardless of the value (true or false) that you set for this parameter. . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_images",
        op_kwargs={
            "ExecutableUsers": executable_users,
            "Filters": filters,
            "ImageIds": image_ids,
            "Owners": owners,
            "IncludeDeprecated": include_deprecated,
            "DryRun": dry_run,
        },
    )


async def export(
    hub,
    ctx,
    disk_image_format: str,
    image_id: str,
    s3_export_location: Dict,
    client_token: str = None,
    description: str = None,
    dry_run: bool = None,
    role_name: str = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Exports an Amazon Machine Image (AMI) to a VM file. For more information, see Exporting a VM directly from an Amazon Machine Image (AMI) in the VM Import/Export User Guide.

    Args:
        client_token(str, optional): Token to enable idempotency for export image requests. Defaults to None.
        description(str, optional): A description of the image being exported. The maximum length is 255 characters. Defaults to None.
        disk_image_format(str): The disk image format.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        image_id(str): The ID of the image.
        s3_export_location(Dict): Information about the destination Amazon S3 bucket. The bucket must exist and grant WRITE and READ_ACP permissions to the AWS account vm-import-export@amazon.com.
        role_name(str, optional): The name of the role that grants VM Import/Export permission to export images to your Amazon S3 bucket. If this parameter is not specified, the default role is named 'vmimport'. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the export image task during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.init.export(ctx, disk_image_format=value, image_id=value, s3_export_location=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.init.export disk_image_format=value, image_id=value, s3_export_location=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="export_image",
        op_kwargs={
            "ClientToken": client_token,
            "Description": description,
            "DiskImageFormat": disk_image_format,
            "DryRun": dry_run,
            "ImageId": image_id,
            "S3ExportLocation": s3_export_location,
            "RoleName": role_name,
            "TagSpecifications": tag_specifications,
        },
    )


async def import_(
    hub,
    ctx,
    architecture: str = None,
    client_data: Dict = None,
    client_token: str = None,
    description: str = None,
    disk_containers: List = None,
    dry_run: bool = None,
    encrypted: bool = None,
    hypervisor: str = None,
    kms_key_id: str = None,
    license_type: str = None,
    platform: str = None,
    role_name: str = None,
    license_specifications: List = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI). For more information, see Importing a VM as an image using VM Import/Export in the VM Import/Export User Guide.

    Args:
        architecture(str, optional): The architecture of the virtual machine. Valid values: i386 | x86_64 | arm64 . Defaults to None.
        client_data(Dict, optional): The client-specific data. Defaults to None.
        client_token(str, optional): The token to enable idempotency for VM import requests. Defaults to None.
        description(str, optional): A description string for the import image task. Defaults to None.
        disk_containers(List, optional): Information about the disk containers. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        encrypted(bool, optional): Specifies whether the destination AMI of the imported image should be encrypted. The default CMK for EBS is used unless you specify a non-default AWS Key Management Service (AWS KMS) CMK using KmsKeyId. For more information, see Amazon EBS Encryption in the Amazon Elastic Compute Cloud User Guide. Defaults to None.
        hypervisor(str, optional): The target hypervisor platform. Valid values: xen . Defaults to None.
        kms_key_id(str, optional): An identifier for the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the encrypted AMI. This parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the default CMK for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.  The CMK identifier may be provided in any of the following formats:    Key ID   Key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the CMK, the AWS account ID of the CMK owner, the alias namespace, and then the CMK alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.   ARN using key ID. The ID ARN contains the arn:aws:kms namespace, followed by the Region of the CMK, the AWS account ID of the CMK owner, the key namespace, and then the CMK ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.   ARN using key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the CMK, the AWS account ID of the CMK owner, the alias namespace, and then the CMK alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.    AWS parses KmsKeyId asynchronously, meaning that the action you call may appear to complete even though you provided an invalid identifier. This action will eventually report failure.  The specified CMK must exist in the Region that the AMI is being copied to. Amazon EBS does not support asymmetric CMKs. Defaults to None.
        license_type(str, optional): The license type to be used for the Amazon Machine Image (AMI) after importing. By default, we detect the source-system operating system (OS) and apply the appropriate license. Specify AWS to replace the source-system license with an AWS license, if appropriate. Specify BYOL to retain the source-system license, if appropriate. To use BYOL, you must have existing licenses with rights to use these licenses in a third party cloud, such as AWS. For more information, see Prerequisites in the VM Import/Export User Guide. Defaults to None.
        platform(str, optional): The operating system of the virtual machine. Valid values: Windows | Linux . Defaults to None.
        role_name(str, optional): The name of the role to use when not using the default role, 'vmimport'. Defaults to None.
        license_specifications(List, optional): The ARNs of the license configurations. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the import image task during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.init.import(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.init.import
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="import_image",
        op_kwargs={
            "Architecture": architecture,
            "ClientData": client_data,
            "ClientToken": client_token,
            "Description": description,
            "DiskContainers": disk_containers,
            "DryRun": dry_run,
            "Encrypted": encrypted,
            "Hypervisor": hypervisor,
            "KmsKeyId": kms_key_id,
            "LicenseType": license_type,
            "Platform": platform,
            "RoleName": role_name,
            "LicenseSpecifications": license_specifications,
            "TagSpecifications": tag_specifications,
        },
    )


async def register(
    hub,
    ctx,
    name: str,
    image_location: str = None,
    architecture: str = None,
    block_device_mappings: List = None,
    description: str = None,
    dry_run: bool = None,
    ena_support: bool = None,
    kernel_id: str = None,
    billing_products: List = None,
    ramdisk_id: str = None,
    root_device_name: str = None,
    sriov_net_support: str = None,
    virtualization_type: str = None,
    boot_mode: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers an AMI. When you're creating an AMI, this is the final step you must complete before you can launch an instance from the AMI. For more information about creating AMIs, see Creating your own AMIs in the Amazon Elastic Compute Cloud User Guide.  For Amazon EBS-backed instances, CreateImage creates and registers the AMI in a single request, so you don't have to register the AMI yourself.  If needed, you can deregister an AMI at any time. Any modifications you make to an AMI backed by an instance store volume invalidates its registration. If you make changes to an image, deregister the previous image and register the new image.  Register a snapshot of a root device volume  You can use RegisterImage to create an Amazon EBS-backed Linux AMI from a snapshot of a root device volume. You specify the snapshot using a block device mapping. You can't set the encryption state of the volume using the block device mapping. If the snapshot is encrypted, or encryption by default is enabled, the root volume of an instance launched from the AMI is encrypted. For more information, see Create a Linux AMI from a snapshot and Use encryption with EBS-backed AMIs in the Amazon Elastic Compute Cloud User Guide.  AWS Marketplace product codes  If any snapshots have AWS Marketplace product codes, they are copied to the new AMI. Windows and some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE Linux Enterprise Server (SLES), use the EC2 billing product code associated with an AMI to verify the subscription status for package updates. To create a new AMI for operating systems that require a billing product code, instead of registering the AMI, do the following to preserve the billing product code association:   Launch an instance from an existing AMI with that billing product code.   Customize the instance.   Create an AMI from the instance using CreateImage.   If you purchase a Reserved Instance to apply to an On-Demand Instance that was launched from an AMI with a billing product code, make sure that the Reserved Instance has the matching billing product code. If you purchase a Reserved Instance without the matching billing product code, the Reserved Instance will not be applied to the On-Demand Instance. For information about how to obtain the platform details and billing information of an AMI, see Obtaining billing information in the Amazon Elastic Compute Cloud User Guide.

    Args:
        image_location(str, optional): The full path to your AMI manifest in Amazon S3 storage. The specified bucket must have the aws-exec-read canned access control list (ACL) to ensure that it can be accessed by Amazon EC2. For more information, see Canned ACLs in the Amazon S3 Service Developer Guide. Defaults to None.
        architecture(str, optional): The architecture of the AMI. Default: For Amazon EBS-backed AMIs, i386. For instance store-backed AMIs, the architecture specified in the manifest file. Defaults to None.
        block_device_mappings(List, optional): The block device mapping entries. If you specify an EBS volume using the ID of an EBS snapshot, you can't specify the encryption state of the volume. If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the Region of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances on the same Outpost only. For more information,  Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide. Defaults to None.
        description(str, optional): A description for your AMI. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        ena_support(bool, optional): Set to true to enable enhanced networking with ENA for the AMI and any instances that you launch from the AMI. This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable. Defaults to None.
        kernel_id(str, optional): The ID of the kernel. Defaults to None.
        name(str): A name for your AMI. Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_).
        billing_products(List, optional): The billing product codes. Your account must be authorized to specify billing product codes. Otherwise, you can use the AWS Marketplace to bill for the use of an AMI. Defaults to None.
        ramdisk_id(str, optional): The ID of the RAM disk. Defaults to None.
        root_device_name(str, optional): The device name of the root device volume (for example, /dev/sda1). Defaults to None.
        sriov_net_support(str, optional): Set to simple to enable enhanced networking with the Intel 82599 Virtual Function interface for the AMI and any instances that you launch from the AMI. There is no way to disable sriovNetSupport at this time. This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable. Defaults to None.
        virtualization_type(str, optional): The type of virtualization (hvm | paravirtual). Default: paravirtual . Defaults to None.
        boot_mode(str, optional): The boot mode of the AMI. For more information, see Boot modes in the Amazon Elastic Compute Cloud User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.init.register(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.init.register name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="register_image",
        op_kwargs={
            "ImageLocation": image_location,
            "Architecture": architecture,
            "BlockDeviceMappings": block_device_mappings,
            "Description": description,
            "DryRun": dry_run,
            "EnaSupport": ena_support,
            "KernelId": kernel_id,
            "Name": name,
            "BillingProducts": billing_products,
            "RamdiskId": ramdisk_id,
            "RootDeviceName": root_device_name,
            "SriovNetSupport": sriov_net_support,
            "VirtualizationType": virtualization_type,
            "BootMode": boot_mode,
        },
    )
