"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, image_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the deprecation of the specified AMI. For more information, see Deprecate an AMI in the Amazon Elastic Compute Cloud User Guide.

    Args:
        image_id(str): The ID of the AMI.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.deprecation.disable(ctx, image_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.deprecation.disable image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disable_image_deprecation",
        op_kwargs={"ImageId": image_id, "DryRun": dry_run},
    )


async def enable(
    hub, ctx, image_id: str, deprecate_at: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Enables deprecation of the specified AMI at the specified date and time. For more information, see Deprecate an AMI in the Amazon Elastic Compute Cloud User Guide.

    Args:
        image_id(str): The ID of the AMI.
        deprecate_at(str): The date and time to deprecate the AMI, in UTC, in the following format: YYYY-MM-DDTHH:MM:SSZ. If you specify a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. You can’t specify a date in the past. The upper limit for DeprecateAt is 10 years from now.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.deprecation.enable(
                ctx, image_id=value, deprecate_at=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.deprecation.enable image_id=value, deprecate_at=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="enable_image_deprecation",
        op_kwargs={"ImageId": image_id, "DeprecateAt": deprecate_at, "DryRun": dry_run},
    )
