"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub, ctx, attribute: str, image_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.

    Args:
        attribute(str): The AMI attribute.  Note: The blockDeviceMapping attribute is deprecated. Using this attribute returns the Client.AuthFailure error. To get information about the block device mappings for an AMI, use the DescribeImages action.
        image_id(str): The ID of the AMI.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.attribute.describe(
                ctx, attribute=value, image_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.attribute.describe attribute=value, image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_image_attribute",
        op_kwargs={"Attribute": attribute, "ImageId": image_id, "DryRun": dry_run},
    )


async def modify(
    hub,
    ctx,
    image_id: str,
    attribute: str = None,
    description: Dict = None,
    launch_permission: Dict = None,
    operation_type: str = None,
    product_codes: List = None,
    user_groups: List = None,
    user_ids: List = None,
    value: str = None,
    dry_run: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time. You can use the Attribute parameter to specify the attribute or one of the following parameters: Description, LaunchPermission, or ProductCode. AWS Marketplace product codes cannot be modified. Images with an AWS Marketplace product code cannot be made public. To enable the SriovNetSupport enhanced networking attribute of an image, enable SriovNetSupport on an instance and create an AMI from the instance.

    Args:
        attribute(str, optional): The name of the attribute to modify. The valid values are description, launchPermission, and productCodes. Defaults to None.
        description(Dict, optional): A new description for the AMI. Defaults to None.
        image_id(str): The ID of the AMI.
        launch_permission(Dict, optional): A new launch permission for the AMI. Defaults to None.
        operation_type(str, optional): The operation type. This parameter can be used only when the Attribute parameter is launchPermission. Defaults to None.
        product_codes(List, optional): The DevPay product codes. After you add a product code to an AMI, it can't be removed. Defaults to None.
        user_groups(List, optional): The user groups. This parameter can be used only when the Attribute parameter is launchPermission. Defaults to None.
        user_ids(List, optional): The AWS account IDs. This parameter can be used only when the Attribute parameter is launchPermission. Defaults to None.
        value(str, optional): The value of the attribute being modified. This parameter can be used only when the Attribute parameter is description or productCodes. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.attribute.modify(ctx, image_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.attribute.modify image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_image_attribute",
        op_kwargs={
            "Attribute": attribute,
            "Description": description,
            "ImageId": image_id,
            "LaunchPermission": launch_permission,
            "OperationType": operation_type,
            "ProductCodes": product_codes,
            "UserGroups": user_groups,
            "UserIds": user_ids,
            "Value": value,
            "DryRun": dry_run,
        },
    )


async def reset(hub, ctx, attribute: str, image_id: str, dry_run: bool = None) -> None:
    r"""
    **Autogenerated function**

    Resets an attribute of an AMI to its default value.  The productCodes attribute can't be reset.

    Args:
        attribute(str): The attribute to reset (currently you can only reset the launch permission attribute).
        image_id(str): The ID of the AMI.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.image.attribute.reset(ctx, attribute=value, image_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.image.attribute.reset attribute=value, image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="reset_image_attribute",
        op_kwargs={"Attribute": attribute, "ImageId": image_id, "DryRun": dry_run},
    )
