"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, iam_instance_profile: Dict, instance_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM instance profile with an instance.

    Args:
        iam_instance_profile(Dict): The IAM instance profile.
        instance_id(str): The ID of the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.iam_instance_profile.init.associate(
                ctx, iam_instance_profile=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.iam_instance_profile.init.associate iam_instance_profile=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="associate_iam_instance_profile",
        op_kwargs={
            "IamInstanceProfile": iam_instance_profile,
            "InstanceId": instance_id,
        },
    )


async def disassociate(hub, ctx, association_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates an IAM instance profile from a running or stopped instance. Use DescribeIamInstanceProfileAssociations to get the association ID.

    Args:
        association_id(str): The ID of the IAM instance profile association.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.iam_instance_profile.init.disassociate(
                ctx, association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.iam_instance_profile.init.disassociate association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disassociate_iam_instance_profile",
        op_kwargs={"AssociationId": association_id},
    )
