"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    association_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes your IAM instance profile associations.

    Args:
        association_ids(List, optional): The IAM instance profile associations. Defaults to None.
        filters(List, optional): The filters.    instance-id - The ID of the instance.    state - The state of the association (associating | associated | disassociating).  . Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.iam_instance_profile.association.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.iam_instance_profile.association.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_iam_instance_profile_associations",
        op_kwargs={
            "AssociationIds": association_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def replace(hub, ctx, iam_instance_profile: Dict, association_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Replaces an IAM instance profile for the specified running instance. You can use this action to change the IAM instance profile that's associated with an instance without having to disassociate the existing IAM instance profile first. Use DescribeIamInstanceProfileAssociations to get the association ID.

    Args:
        iam_instance_profile(Dict): The IAM instance profile.
        association_id(str): The ID of the existing IAM instance profile association.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.iam_instance_profile.association.replace(
                ctx, iam_instance_profile=value, association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.iam_instance_profile.association.replace iam_instance_profile=value, association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="replace_iam_instance_profile_association",
        op_kwargs={
            "IamInstanceProfile": iam_instance_profile,
            "AssociationId": association_id,
        },
    )
