"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, host_id_set: List, offering_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Preview a reservation purchase with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation. This is a preview of the PurchaseHostReservation action and does not result in the offering being purchased.

    Args:
        host_id_set(List): The IDs of the Dedicated Hosts with which the reservation is associated.
        offering_id(str): The offering ID of the reservation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.host.reservation.purchase_preview.get(
                ctx, host_id_set=value, offering_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.host.reservation.purchase_preview.get host_id_set=value, offering_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_host_reservation_purchase_preview",
        op_kwargs={"HostIdSet": host_id_set, "OfferingId": offering_id},
    )
